/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterators;
import io.netty.util.AttributeKey;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class DefaultAttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, AtomicReferenceArray> updater = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, AtomicReferenceArray.class, "attributes");
    private static final int BUCKET_SIZE = 8;
    private static final int MASK = 7;
    @Nullable
    volatile AtomicReferenceArray<DefaultAttribute<?>> attributes;
    @Nullable
    private final RequestContext rootAttributeMap;

    DefaultAttributeMap(@Nullable RequestContext rootAttributeMap) {
        this.rootAttributeMap = rootAttributeMap;
    }

    @Nullable
    <T> T ownAttr(AttributeKey<T> key) {
        return this.attr(key, true);
    }

    @Nullable
    <T> T attr(AttributeKey<T> key) {
        return this.attr(key, false);
    }

    @Nullable
    private <T> T attr(AttributeKey<T> key, boolean ownAttr) {
        Objects.requireNonNull(key, "key");
        AtomicReferenceArray<DefaultAttribute<?>> attributes = this.attributes;
        if (attributes == null) {
            if (!ownAttr && this.rootAttributeMap != null) {
                return this.rootAttributeMap.attr(key);
            }
            return null;
        }
        int i = DefaultAttributeMap.index(key);
        DefaultAttribute head = attributes.get(i);
        if (head == null) {
            if (!ownAttr && this.rootAttributeMap != null) {
                return this.rootAttributeMap.attr(key);
            }
            return null;
        }
        DefaultAttribute defaultAttribute = head;
        synchronized (defaultAttribute) {
            DefaultAttribute curr = head;
            while (true) {
                DefaultAttribute next;
                if ((next = curr.next) == null) {
                    if (!ownAttr && this.rootAttributeMap != null) {
                        return this.rootAttributeMap.attr(key);
                    }
                    return null;
                }
                if (next.key == key) {
                    Object result = next.getValue();
                    return result;
                }
                curr = next;
            }
        }
    }

    private static int index(AttributeKey<?> key) {
        return key.id() & 7;
    }

    @Nullable
    <T> T setAttr(AttributeKey<T> key, @Nullable T value) {
        return (T)this.setAttr(key, value, SetAttrMode.OLD_VALUE);
    }

    @Nullable
    private <T> Object setAttr(AttributeKey<T> key, @Nullable T value, SetAttrMode mode) {
        Objects.requireNonNull(key, "key");
        AtomicReferenceArray<DefaultAttribute<?>> attributes = this.attributes();
        int i = DefaultAttributeMap.index(key);
        DefaultAttribute<Object> head = attributes.get(i);
        if (head == null) {
            head = new DefaultAttribute();
            DefaultAttribute<T> attr = new DefaultAttribute<T>(key, value);
            ((DefaultAttribute)head).next = (DefaultAttribute)attr;
            if (attributes.compareAndSet(i, null, head)) {
                return this.getSetAttrResultForNewAttr(mode, attr);
            }
            head = attributes.get(i);
        }
        DefaultAttribute<?> defaultAttribute = head;
        synchronized (defaultAttribute) {
            DefaultAttribute curr = head;
            while (true) {
                DefaultAttribute next;
                if ((next = curr.next) != null && next.key == key) {
                    DefaultAttribute attr = next;
                    T oldValue = attr.setValue(value);
                    return DefaultAttributeMap.getSetAttrResultForExistingAttr(mode, attr, oldValue);
                }
                if (next == null) {
                    DefaultAttribute<T> attr = new DefaultAttribute<T>(key, value);
                    curr.next = (DefaultAttribute)attr;
                    return this.getSetAttrResultForNewAttr(mode, attr);
                }
                curr = next;
            }
        }
    }

    @Nullable
    private <T> Object getSetAttrResultForNewAttr(SetAttrMode mode, DefaultAttribute<T> attr) {
        switch (mode) {
            case OLD_VALUE: {
                return this.rootAttributeMap != null ? this.rootAttributeMap.ownAttr(attr.getKey()) : null;
            }
            case CUR_ATTR: {
                return attr;
            }
        }
        throw new Error();
    }

    @Nullable
    private static <T> Object getSetAttrResultForExistingAttr(SetAttrMode mode, DefaultAttribute<T> attr, @Nullable T oldValue) {
        switch (mode) {
            case OLD_VALUE: {
                return oldValue;
            }
            case CUR_ATTR: {
                return attr;
            }
        }
        throw new Error();
    }

    private AtomicReferenceArray<DefaultAttribute<?>> attributes() {
        AtomicReferenceArray<DefaultAttribute<Object>> attributes = this.attributes;
        if (attributes == null && !updater.compareAndSet(this, null, attributes = new AtomicReferenceArray(8))) {
            attributes = this.attributes;
        }
        assert (attributes != null);
        return attributes;
    }

    Iterator<Map.Entry<AttributeKey<?>, Object>> attrs() {
        AtomicReferenceArray<DefaultAttribute<?>> attributes = this.attributes;
        if (attributes == null) {
            if (this.rootAttributeMap == null) {
                return Collections.emptyIterator();
            }
            Iterator<Map.Entry<AttributeKey<?>, Object>> rootAttrs = this.rootAttributeMap.attrs();
            if (!rootAttrs.hasNext()) {
                return Collections.emptyIterator();
            }
            return new CopyOnWriteIterator(rootAttrs);
        }
        OwnIterator ownAttrsIt = new OwnIterator(attributes);
        if (this.rootAttributeMap == null) {
            return ownAttrsIt;
        }
        Iterator<Map.Entry<AttributeKey<?>, Object>> rootAttrs = this.rootAttributeMap.attrs();
        if (!rootAttrs.hasNext()) {
            return ownAttrsIt;
        }
        return new ConcatenatedCopyOnWriteIterator(ownAttrsIt, rootAttrs);
    }

    Iterator<Map.Entry<AttributeKey<?>, Object>> ownAttrs() {
        AtomicReferenceArray<DefaultAttribute<?>> attributes = this.attributes;
        if (attributes == null) {
            return Collections.emptyIterator();
        }
        return new OwnIterator(attributes);
    }

    private static <T> T convert(Object o) {
        return (T)o;
    }

    public String toString() {
        return Iterators.toString(this.attrs());
    }

    private static enum SetAttrMode {
        OLD_VALUE,
        CUR_ATTR;

    }

    static final class DefaultAttribute<T>
    implements Map.Entry<AttributeKey<T>, T> {
        @Nullable
        private final AttributeKey<T> key;
        @Nullable
        private volatile T value;
        @Nullable
        private DefaultAttribute<?> next;

        DefaultAttribute(AttributeKey<T> key, @Nullable T value) {
            this.key = key;
            this.value = value;
        }

        DefaultAttribute() {
            this.key = null;
            this.value = null;
        }

        @Override
        public AttributeKey<T> getKey() {
            assert (this.key != null);
            return this.key;
        }

        @Override
        @Nullable
        public T getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public T setValue(@Nullable T value) {
            T old = this.value;
            this.value = value;
            return old;
        }

        public String toString() {
            return this.key == null ? "<HEAD>" : this.key + "=" + this.value;
        }
    }

    private class CopyOnWriteIterator
    implements Iterator<Map.Entry<AttributeKey<?>, Object>> {
        private final Iterator<Map.Entry<AttributeKey<?>, Object>> rootAttrs;

        CopyOnWriteIterator(Iterator<Map.Entry<AttributeKey<?>, Object>> rootAttrs) {
            this.rootAttrs = rootAttrs;
        }

        @Override
        public boolean hasNext() {
            return this.rootAttrs.hasNext();
        }

        @Override
        public Map.Entry<AttributeKey<?>, Object> next() {
            return new CopyOnWriteAttribute<Object>(this.rootAttrs.next());
        }
    }

    private static final class OwnIterator
    implements Iterator<Map.Entry<AttributeKey<?>, Object>> {
        private final AtomicReferenceArray<DefaultAttribute<?>> attributes;
        private int idx = -1;
        @Nullable
        private DefaultAttribute<?> next;

        OwnIterator(AtomicReferenceArray<DefaultAttribute<?>> attributes) {
            this.attributes = attributes;
            this.next = this.findNext(null);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<AttributeKey<?>, Object> next() {
            DefaultAttribute<?> next = this.next;
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext(((DefaultAttribute)next).next);
            return (Map.Entry)DefaultAttributeMap.convert(next);
        }

        @Nullable
        private DefaultAttribute<?> findNext(@Nullable DefaultAttribute<?> next) {
            block0: while (true) {
                if (next == null) {
                    ++this.idx;
                    while (this.idx < this.attributes.length()) {
                        DefaultAttribute<?> head = this.attributes.get(this.idx);
                        if (head != null && ((DefaultAttribute)head).next != null) {
                            next = ((DefaultAttribute)head).next;
                            break;
                        }
                        ++this.idx;
                    }
                    if (next == null) {
                        return null;
                    }
                }
                while (next.getValue() == null) {
                    if ((next = next.next) != null) continue;
                    continue block0;
                }
                break;
            }
            return next;
        }
    }

    private final class ConcatenatedCopyOnWriteIterator
    implements Iterator<Map.Entry<AttributeKey<?>, Object>> {
        private final Iterator<Map.Entry<AttributeKey<?>, Object>> childIt;
        private final Iterator<Map.Entry<AttributeKey<?>, Object>> rootIt;
        @Nullable
        private Map.Entry<AttributeKey<?>, Object> next;

        ConcatenatedCopyOnWriteIterator(Iterator<Map.Entry<AttributeKey<?>, Object>> childIt, Iterator<Map.Entry<AttributeKey<?>, Object>> rootIt) {
            this.childIt = childIt;
            this.rootIt = rootIt;
            this.next = childIt.hasNext() ? childIt.next() : (rootIt.hasNext() ? (Map.Entry)DefaultAttributeMap.convert(new CopyOnWriteAttribute((Map.Entry)DefaultAttributeMap.convert(rootIt.next()))) : null);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<AttributeKey<?>, Object> next() {
            Map.Entry<AttributeKey<?>, Object> next;
            block4: {
                next = this.next;
                if (next == null) {
                    throw new NoSuchElementException();
                }
                if (this.childIt.hasNext()) {
                    this.next = this.childIt.next();
                } else {
                    while (this.rootIt.hasNext()) {
                        Map.Entry<AttributeKey<?>, Object> tempNext = this.rootIt.next();
                        if (DefaultAttributeMap.this.ownAttr(tempNext.getKey()) != null) continue;
                        this.next = (Map.Entry)DefaultAttributeMap.convert(new CopyOnWriteAttribute((Map.Entry)DefaultAttributeMap.convert(tempNext)));
                        break block4;
                    }
                    this.next = null;
                }
            }
            return next;
        }
    }

    private final class CopyOnWriteAttribute<T>
    implements Map.Entry<AttributeKey<T>, T> {
        private final Map.Entry<AttributeKey<T>, T> rootAttr;
        @Nullable
        private volatile Map.Entry<AttributeKey<T>, T> childAttr;

        CopyOnWriteAttribute(Map.Entry<AttributeKey<T>, T> rootAttr) {
            this.rootAttr = rootAttr;
        }

        @Override
        public AttributeKey<T> getKey() {
            return this.rootAttr.getKey();
        }

        @Override
        public T getValue() {
            Map.Entry<AttributeKey<T>, T> childAttr = this.childAttr;
            if (childAttr != null) {
                return childAttr.getValue();
            }
            return this.rootAttr.getValue();
        }

        @Override
        public T setValue(T value) {
            Map.Entry<AttributeKey<T>, T> childAttr = this.childAttr;
            if (childAttr == null) {
                Map.Entry newChildAttr;
                this.childAttr = newChildAttr = (Map.Entry)DefaultAttributeMap.this.setAttr(this.rootAttr.getKey(), value, SetAttrMode.CUR_ATTR);
                return this.rootAttr.getValue();
            }
            T old = childAttr.getValue();
            childAttr.setValue(value);
            return old;
        }

        public String toString() {
            return MoreObjects.firstNonNull(this.childAttr, this.rootAttr).toString();
        }
    }
}

