/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

public final class ContentTooLargeExceptionBuilder {
    private long maxContentLength = -1L;
    private long contentLength = -1L;
    private long transferred = -1L;

    ContentTooLargeExceptionBuilder() {
    }

    public ContentTooLargeExceptionBuilder maxContentLength(long maxContentLength) {
        Preconditions.checkArgument(maxContentLength >= 0L, "maxContentLength: %s (expected: >= 0)", maxContentLength);
        this.maxContentLength = maxContentLength;
        return this;
    }

    public ContentTooLargeExceptionBuilder contentLength(long contentLength) {
        Preconditions.checkArgument(contentLength >= 0L, "contentLength: %s (expected: >= 0)", contentLength);
        this.contentLength = contentLength;
        return this;
    }

    public ContentTooLargeExceptionBuilder contentLength(HttpHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        this.contentLength = headers.contentLength();
        return this;
    }

    public ContentTooLargeExceptionBuilder transferred(long transferred) {
        Preconditions.checkArgument(transferred >= 0L, "transferred: %s (expected: >= 0)", transferred);
        this.transferred = transferred;
        return this;
    }

    public ContentTooLargeException build() {
        if (this.maxContentLength < 0L && this.contentLength < 0L && this.transferred < 0L) {
            return ContentTooLargeException.get();
        }
        return new ContentTooLargeException(this.maxContentLength, this.contentLength, this.transferred);
    }
}

