/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContentTooLargeExceptionBuilder;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;

public final class ContentTooLargeException
extends RuntimeException {
    private static final long serialVersionUID = 4901614315474105954L;
    private static final ContentTooLargeException INSTANCE = new ContentTooLargeException(true);
    private final boolean neverSample;
    private final long maxContentLength;
    private final long contentLength;
    private final long transferred;

    public static ContentTooLargeException get() {
        return Flags.verboseExceptionSampler().isSampled(ContentTooLargeException.class) ? new ContentTooLargeException() : INSTANCE;
    }

    public static ContentTooLargeExceptionBuilder builder() {
        return new ContentTooLargeExceptionBuilder();
    }

    private ContentTooLargeException() {
        this(false);
    }

    private ContentTooLargeException(boolean neverSample) {
        super(null, null, !neverSample, !neverSample);
        this.neverSample = neverSample;
        this.maxContentLength = -1L;
        this.transferred = -1L;
        this.contentLength = -1L;
    }

    ContentTooLargeException(long maxContentLength, long contentLength, long transferred) {
        super(ContentTooLargeException.toString(maxContentLength, contentLength, transferred));
        this.neverSample = false;
        this.transferred = transferred;
        this.contentLength = contentLength;
        this.maxContentLength = maxContentLength;
    }

    public long transferred() {
        return this.transferred;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public long maxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public Throwable fillInStackTrace() {
        if (!this.neverSample && Flags.verboseExceptionSampler().isSampled(this.getClass())) {
            super.fillInStackTrace();
        }
        return this;
    }

    @Nullable
    private static String toString(long maxContentLength, long contentLength, long transferred) {
        try (TemporaryThreadLocals ttl = TemporaryThreadLocals.acquire();){
            StringBuilder buf = ttl.stringBuilder();
            if (maxContentLength >= 0L) {
                buf.append(", maxContentLength: ").append(maxContentLength);
            }
            if (contentLength >= 0L) {
                buf.append(", contentLength: ").append(contentLength);
            }
            if (transferred >= 0L) {
                buf.append(", transferred: ").append(transferred);
            }
            String string = buf.length() != 0 ? buf.substring(2) : null;
            return string;
        }
    }
}

