/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ByteArrayHttpData;
import com.linecorp.armeria.common.ByteBufAccessMode;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.fastutil.io.FastByteArrayInputStream;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ResourceLeakHint;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;

final class ByteBufHttpData
implements HttpData,
ResourceLeakHint {
    private static final int FLAG_POOLED = 1;
    private static final int FLAG_END_OF_STREAM = 2;
    private static final int FLAG_CLOSED = 4;
    private final ByteBuf buf;
    @Nullable
    private byte[] array;
    private int flags;

    ByteBufHttpData(ByteBuf buf, boolean pooled) {
        this(buf, pooled ? 1 : 0, null);
    }

    private ByteBufHttpData(ByteBuf buf, int flags, @Nullable byte[] array) {
        this.buf = buf;
        this.array = array;
        this.flags = flags;
    }

    @Override
    public byte[] array() {
        byte[] bufArray;
        if (this.array != null) {
            return this.array;
        }
        int length = this.buf.readableBytes();
        if (this.isPooled()) {
            this.buf.touch((Object)this);
        } else if (this.buf.hasArray() && this.buf.arrayOffset() == 0 && this.buf.readerIndex() == 0 && (bufArray = this.buf.array()).length == length) {
            this.array = bufArray;
            return bufArray;
        }
        this.array = ByteBufUtil.getBytes((ByteBuf)this.buf, (int)this.buf.readerIndex(), (int)length);
        return this.array;
    }

    @Override
    public int length() {
        return this.buf.readableBytes();
    }

    @Override
    public String toString(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        if (this.array != null) {
            return new String(this.array, charset);
        }
        return this.buf.toString(charset);
    }

    public String toString() {
        return this.toString(false);
    }

    /*
     * Unable to fully structure code
     */
    private String toString(boolean hint) {
        length = this.buf.readableBytes();
        tempThreadLocals = TemporaryThreadLocals.acquire();
        try {
            strBuf = tempThreadLocals.stringBuilder();
            strBuf.append('{').append(length).append("B, ");
            if (this.isEndOfStream()) {
                strBuf.append("EOS, ");
            }
            if (this.isPooled()) {
                strBuf.append("pooled, ");
            }
            if ((this.flags & 4) != 0) {
                if (this.buf.refCnt() == 0) {
                    var5_6 = strBuf.append("closed}").toString();
                    return var5_6;
                }
                strBuf.append("closed, ");
            }
            previewLength = Math.min(16, length);
            array = this.array;
            if (array == null) {
                try {
                    if (this.buf.hasArray()) {
                        array = this.buf.array();
                        offset = this.buf.arrayOffset() + this.buf.readerIndex();
                    }
                    if (!hint) {
                        array = ByteBufUtil.getBytes((ByteBuf)this.buf, (int)this.buf.readerIndex(), (int)previewLength);
                        offset = 0;
                        if (previewLength != length) ** GOTO lbl39
                        this.array = array;
                    }
                    var8_11 = strBuf.append("<unknown>}").toString();
                    return var8_11;
                }
                catch (IllegalReferenceCountException e) {
                    var9_14 = strBuf.append("badRefCnt}").toString();
                    return var9_14;
                }
            } else {
                offset = 0;
            }
lbl39:
            // 4 sources

            var8_13 = ByteArrayHttpData.appendPreviews(strBuf, array, offset, previewLength).append('}').toString();
            return var8_13;
        }
        finally {
            if (tempThreadLocals != null) {
                tempThreadLocals.close();
            }
        }
    }

    public String toHintString() {
        return this.toString(true);
    }

    @Override
    public InputStream toInputStream() {
        if (this.array != null) {
            return new FastByteArrayInputStream(this.array);
        }
        return new ByteBufInputStream(this.buf.duplicate(), false);
    }

    @Override
    public boolean isEndOfStream() {
        return (this.flags & 2) != 0;
    }

    @Override
    public ByteBufHttpData withEndOfStream(boolean endOfStream) {
        if (this.isEndOfStream() == endOfStream) {
            return this;
        }
        int newFlags = this.flags & 0xFFFFFFFD;
        if (endOfStream) {
            newFlags |= 2;
        }
        return new ByteBufHttpData(this.buf, newFlags, this.array);
    }

    @Override
    public boolean isPooled() {
        return (this.flags & 1) != 0;
    }

    @Override
    public ByteBuf byteBuf(ByteBufAccessMode mode) {
        switch (Objects.requireNonNull(mode, "mode")) {
            case DUPLICATE: {
                return this.buf.duplicate();
            }
            case RETAINED_DUPLICATE: {
                return this.buf.retainedDuplicate();
            }
            case FOR_IO: {
                if (this.buf.isDirect()) {
                    return this.buf.retainedDuplicate();
                }
                ByteBuf copy = this.newDirectByteBuf();
                copy.writeBytes(this.buf, this.buf.readerIndex(), this.buf.readableBytes());
                return copy;
            }
        }
        throw new Error();
    }

    @Override
    public ByteBuf byteBuf(int offset, int length, ByteBufAccessMode mode) {
        int startIndex = this.buf.readerIndex() + offset;
        switch (Objects.requireNonNull(mode, "mode")) {
            case DUPLICATE: {
                return this.buf.slice(startIndex, length);
            }
            case RETAINED_DUPLICATE: {
                return this.buf.retainedSlice(startIndex, length);
            }
            case FOR_IO: {
                if (this.buf.isDirect()) {
                    return this.buf.retainedSlice(startIndex, length);
                }
                ByteBuf copy = ByteBufHttpData.newDirectByteBuf(length);
                copy.writeBytes(this.buf, startIndex, length);
                return copy;
            }
        }
        throw new Error();
    }

    private ByteBuf newDirectByteBuf() {
        return ByteBufHttpData.newDirectByteBuf(this.buf.readableBytes());
    }

    private static ByteBuf newDirectByteBuf(int length) {
        return PooledByteBufAllocator.DEFAULT.directBuffer(length);
    }

    @Override
    public void touch(@Nullable Object hint) {
        if (this.isPooled()) {
            this.buf.touch((Object)MoreObjects.firstNonNull(hint, this));
        }
    }

    @Override
    public void close() {
        if ((this.flags & 5) == 1) {
            this.flags |= 4;
            this.buf.release();
        }
    }

    public int hashCode() {
        int hash = 0;
        int bufStart = this.buf.readerIndex();
        int bufEnd = bufStart + Math.min(32, this.buf.readableBytes());
        for (int i = bufStart; i < bufEnd; ++i) {
            hash = hash * 31 + this.buf.getByte(i);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpData)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        HttpData that = (HttpData)obj;
        if (this.buf.readableBytes() != that.length()) {
            return false;
        }
        return ByteBufUtil.equals((ByteBuf)this.buf, (ByteBuf)that.byteBuf());
    }
}

