/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ByteBufAccessMode;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.fastutil.io.FastByteArrayInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.EmptyArrays;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;

final class ByteArrayHttpData
implements HttpData {
    static final ByteArrayHttpData EMPTY = new ByteArrayHttpData(EmptyArrays.EMPTY_BYTES, false);
    static final ByteArrayHttpData EMPTY_EOS = new ByteArrayHttpData(EmptyArrays.EMPTY_BYTES, true);
    private static final byte[] SAFE_OCTETS = new byte[256];
    private final byte[] array;
    private final boolean endOfStream;

    ByteArrayHttpData(byte[] array) {
        this(array, false);
    }

    private ByteArrayHttpData(byte[] array, boolean endOfStream) {
        this.array = array;
        this.endOfStream = endOfStream;
    }

    @Override
    public byte[] array() {
        return this.array;
    }

    @Override
    public int length() {
        return this.array.length;
    }

    @Override
    public String toString(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return new String(this.array, charset);
    }

    public String toString() {
        if (this.array.length == 0) {
            return this.isEndOfStream() ? "{0B, EOS}" : "{0B}";
        }
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append('{').append(this.array.length);
            if (this.isEndOfStream()) {
                buf.append("B, EOS, ");
            } else {
                buf.append("B, ");
            }
            String string = ByteArrayHttpData.appendPreviews(buf, this.array, 0, Math.min(16, this.array.length)).append('}').toString();
            return string;
        }
    }

    static StringBuilder appendPreviews(StringBuilder buf, byte[] array, int offset, int previewLength) {
        int endOffset = offset + previewLength;
        for (int i = offset; i < endOffset; ++i) {
            if (SAFE_OCTETS[array[i] & 0xFF] != 0) continue;
            return buf.append("hex=").append(ByteBufUtil.hexDump((byte[])array, (int)offset, (int)previewLength));
        }
        return buf.append("text=").append(new String(array, 0, offset, previewLength));
    }

    @Override
    public InputStream toInputStream() {
        return new FastByteArrayInputStream(this.array);
    }

    @Override
    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    @Override
    public ByteArrayHttpData withEndOfStream(boolean endOfStream) {
        if (this.isEndOfStream() == endOfStream) {
            return this;
        }
        if (this.isEmpty()) {
            return endOfStream ? EMPTY_EOS : EMPTY;
        }
        return new ByteArrayHttpData(this.array, endOfStream);
    }

    @Override
    public boolean isPooled() {
        return false;
    }

    @Override
    public ByteBuf byteBuf(ByteBufAccessMode mode) {
        Objects.requireNonNull(mode, "mode");
        if (this.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (mode != ByteBufAccessMode.FOR_IO) {
            return Unpooled.wrappedBuffer((byte[])this.array);
        }
        ByteBuf copy = this.newDirectByteBuf();
        copy.writeBytes(this.array);
        return copy;
    }

    @Override
    public ByteBuf byteBuf(int offset, int length, ByteBufAccessMode mode) {
        Objects.requireNonNull(mode, "mode");
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (mode != ByteBufAccessMode.FOR_IO) {
            return Unpooled.wrappedBuffer((byte[])this.array, (int)offset, (int)length);
        }
        ByteBuf copy = ByteArrayHttpData.newDirectByteBuf(length);
        copy.writeBytes(this.array, offset, length);
        return copy;
    }

    private ByteBuf newDirectByteBuf() {
        return ByteArrayHttpData.newDirectByteBuf(this.length());
    }

    private static ByteBuf newDirectByteBuf(int length) {
        return PooledByteBufAllocator.DEFAULT.directBuffer(length);
    }

    @Override
    public void close() {
    }

    public int hashCode() {
        int end = Math.min(32, this.length());
        int hash = 0;
        for (int i = 0; i < end; ++i) {
            hash = hash * 31 + this.array[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpData)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        HttpData that = (HttpData)obj;
        if (this.length() != that.length()) {
            return false;
        }
        return Arrays.equals(this.array, that.array());
    }

    static {
        String safeOctetStr = "`~!@#$%^&*()-_=+\t[{]}\\|;:'\",<.>/?abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        for (int i = 0; i < "`~!@#$%^&*()-_=+\t[{]}\\|;:'\",<.>/?abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length(); ++i) {
            ByteArrayHttpData.SAFE_OCTETS["`~!@#$%^&*()-_=+\t[{]}\\|;:'\",<.>/?abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt((int)i)] = -1;
        }
    }
}

