/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.reactivestreams.Publisher;

abstract class AbstractHttpMessageBuilder {
    @Nullable
    private HttpData content;
    @Nullable
    private Publisher<? extends HttpData> publisher;
    @Nullable
    private HttpHeadersBuilder httpTrailers;

    AbstractHttpMessageBuilder() {
    }

    @Nullable
    final HttpData content() {
        return this.content;
    }

    @Nullable
    final Publisher<? extends HttpData> publisher() {
        return this.publisher;
    }

    @Nullable
    final HttpHeadersBuilder httpTrailers() {
        return this.httpTrailers;
    }

    abstract HttpHeadersBuilder headersBuilder();

    AbstractHttpMessageBuilder header(CharSequence name, Object value) {
        this.headersBuilder().addObject(Objects.requireNonNull(name, "name"), Objects.requireNonNull(value, "value"));
        return this;
    }

    AbstractHttpMessageBuilder headers(Iterable<? extends Map.Entry<? extends CharSequence, String>> headers) {
        Objects.requireNonNull(headers, "headers");
        this.headersBuilder().add(headers);
        return this;
    }

    AbstractHttpMessageBuilder content(String content) {
        return this.content(MediaType.PLAIN_TEXT_UTF_8, content);
    }

    AbstractHttpMessageBuilder content(MediaType contentType, CharSequence content) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(content, "content");
        return this.content(contentType, HttpData.of(contentType.charset(StandardCharsets.UTF_8), content));
    }

    AbstractHttpMessageBuilder content(MediaType contentType, String content) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(content, "content");
        return this.content(contentType, HttpData.of(contentType.charset(StandardCharsets.UTF_8), content));
    }

    @FormatMethod
    AbstractHttpMessageBuilder content(@FormatString String format, Object ... content) {
        return this.content(MediaType.PLAIN_TEXT_UTF_8, format, content);
    }

    @FormatMethod
    AbstractHttpMessageBuilder content(MediaType contentType, @FormatString String format, Object ... content) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(content, "content");
        return this.content(contentType, HttpData.of(contentType.charset(StandardCharsets.UTF_8), format, content));
    }

    AbstractHttpMessageBuilder content(MediaType contentType, byte[] content) {
        Objects.requireNonNull(content, "content");
        return this.content(contentType, HttpData.wrap(content));
    }

    AbstractHttpMessageBuilder content(MediaType contentType, HttpData content) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(content, "content");
        Preconditions.checkState(this.publisher == null, "publisher has been set already");
        this.headersBuilder().contentType(contentType);
        this.content = content;
        return this;
    }

    AbstractHttpMessageBuilder content(MediaType contentType, Publisher<? extends HttpData> publisher) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(publisher, "publisher");
        Preconditions.checkState(this.content == null, "content has been set already");
        this.headersBuilder().contentType(contentType);
        this.publisher = publisher;
        return this;
    }

    AbstractHttpMessageBuilder contentJson(Object content) {
        Objects.requireNonNull(content, "content");
        Preconditions.checkState(this.publisher == null, "publisher has been set already");
        try {
            return this.content(MediaType.JSON, HttpData.wrap(JacksonUtil.writeValueAsBytes(content)));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("failed to serialize " + content, e);
        }
    }

    AbstractHttpMessageBuilder trailers(Iterable<? extends Map.Entry<? extends CharSequence, String>> trailers) {
        Objects.requireNonNull(trailers, "trailers");
        if (this.httpTrailers == null) {
            this.httpTrailers = HttpHeaders.builder();
        }
        this.httpTrailers.add(trailers);
        return this;
    }
}

