/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AbstractContextAwareScheduledExecutorService;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractContextAwareExecutorService<ES extends ExecutorService>
implements ExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractContextAwareScheduledExecutorService.class);
    final ES executor;

    AbstractContextAwareExecutorService(ES executor) {
        this.executor = (ExecutorService)Objects.requireNonNull(executor, "executor");
    }

    @Nullable
    abstract RequestContext contextOrNull();

    @Override
    public final void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    final Runnable makeContextAware(Runnable task) {
        RequestContext context = this.contextOrNull();
        return context == null ? task : context.makeContextAware(task);
    }

    final <T> Callable<T> makeContextAware(Callable<T> task) {
        RequestContext context = this.contextOrNull();
        return context == null ? task : context.makeContextAware(task);
    }

    private <T> Collection<? extends Callable<T>> makeContextAware(Collection<? extends Callable<T>> tasks) {
        return Objects.requireNonNull(tasks, "tasks").stream().map(this::makeContextAware).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(this.makeContextAware(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(this.makeContextAware(task), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(this.makeContextAware(task));
    }

    @Override
    public final boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(this.makeContextAware(tasks));
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(this.makeContextAware(tasks), timeout, unit);
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(this.makeContextAware(tasks));
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(this.makeContextAware(tasks), timeout, unit);
    }

    @Override
    public final void execute(Runnable command) {
        this.executor.execute(this.makeContextAware(command));
    }

    static enum LogRequestContextWarningOnce implements Supplier<RequestContext>
    {
        INSTANCE;


        @Override
        @Nullable
        public RequestContext get() {
            ClassLoaderHack.loadMe();
            return null;
        }

        private static final class ClassLoaderHack {
            private ClassLoaderHack() {
            }

            static void loadMe() {
            }

            static {
                logger.warn("Attempted to propagate request context to an executor task, but no request context available. If this executor is used for non-request-related tasks then it's safe to ignore this", (Throwable)new NoRequestContextException());
            }
        }

        private static final class NoRequestContextException
        extends RuntimeException {
            private static final long serialVersionUID = 2804189311774982052L;

            private NoRequestContextException() {
            }
        }
    }
}

