/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.RetryConfig;
import com.linecorp.armeria.client.retry.RetryConfigMapping;
import com.linecorp.armeria.client.retry.RetryRule;
import com.linecorp.armeria.client.retry.RetryRuleWithContent;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.internal.client.ClientUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryingClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRetryingClient.class);
    public static final AsciiString ARMERIA_RETRY_COUNT = HttpHeaderNames.of("armeria-retry-count");
    private static final AttributeKey<State> STATE = AttributeKey.valueOf(AbstractRetryingClient.class, (String)"STATE");
    private final RetryConfigMapping<O> mapping;
    @Nullable
    private final RetryConfig<O> retryConfig;

    AbstractRetryingClient(Client<I, O> delegate, RetryConfigMapping<O> mapping, @Nullable RetryConfig<O> retryConfig) {
        super(delegate);
        this.mapping = Objects.requireNonNull(mapping, "mapping");
        this.retryConfig = retryConfig;
    }

    @Override
    public final O execute(ClientRequestContext ctx, I req) throws Exception {
        RetryConfig<O> config = this.mapping.get(ctx, (Request)req);
        Objects.requireNonNull(config, "mapping.get() returned null");
        State state = new State(config.maxTotalAttempts(), config.responseTimeoutMillisForEachAttempt(), ctx.responseTimeoutMillis());
        ctx.setAttr(STATE, state);
        return this.doExecute(ctx, req);
    }

    protected final RetryConfigMapping<O> mapping() {
        return this.mapping;
    }

    protected abstract O doExecute(ClientRequestContext var1, I var2) throws Exception;

    protected static void onRetryingComplete(ClientRequestContext ctx) {
        ctx.logBuilder().endResponseWithLastChild();
    }

    protected final RetryRule retryRule() {
        Preconditions.checkState(this.retryConfig != null, "No retryRule set. Are you using RetryConfigMapping?");
        RetryRule retryRule = this.retryConfig.retryRule();
        Preconditions.checkState(retryRule != null, "retryRule is not set.");
        return retryRule;
    }

    protected final RetryRuleWithContent<O> retryRuleWithContent() {
        Preconditions.checkState(this.retryConfig != null, "No retryRuleWithContent set. Are you using RetryConfigMapping?");
        RetryRuleWithContent<O> retryRuleWithContent = this.retryConfig.retryRuleWithContent();
        Preconditions.checkState(retryRuleWithContent != null, "retryRuleWithContent is not set.");
        return retryRuleWithContent;
    }

    protected static void scheduleNextRetry(ClientRequestContext ctx, Consumer<? super Throwable> actionOnException, Runnable retryTask, long nextDelayMillis) {
        try {
            if (nextDelayMillis == 0L) {
                ctx.eventLoop().execute(retryTask);
            } else {
                ScheduledFuture scheduledFuture = ctx.eventLoop().schedule(retryTask, nextDelayMillis, TimeUnit.MILLISECONDS);
                scheduledFuture.addListener(future -> {
                    if (future.isCancelled()) {
                        actionOnException.accept(new IllegalStateException(ClientFactory.class.getSimpleName() + " has been closed."));
                    } else if (future.cause() != null) {
                        actionOnException.accept(future.cause());
                    }
                });
            }
        }
        catch (Throwable t) {
            actionOnException.accept(t);
        }
    }

    protected final boolean setResponseTimeout(ClientRequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        long responseTimeoutMillis = ctx.attr(STATE).responseTimeoutMillis();
        if (responseTimeoutMillis < 0L) {
            return false;
        }
        if (responseTimeoutMillis == 0L) {
            ctx.clearResponseTimeout();
            return true;
        }
        ctx.setResponseTimeoutMillis(TimeoutMode.SET_FROM_NOW, responseTimeoutMillis);
        return true;
    }

    protected final long getNextDelay(ClientRequestContext ctx, Backoff backoff) {
        return this.getNextDelay(ctx, backoff, -1L);
    }

    protected final long getNextDelay(ClientRequestContext ctx, Backoff backoff, long millisAfterFromServer) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(backoff, "backoff");
        State state = ctx.attr(STATE);
        int currentAttemptNo = state.currentAttemptNoWith(backoff);
        if (currentAttemptNo < 0) {
            logger.debug("Exceeded the default number of max attempt: {}", (Object)state.maxTotalAttempts);
            return -1L;
        }
        long nextDelay = backoff.nextDelayMillis(currentAttemptNo);
        if (nextDelay < 0L) {
            logger.debug("Exceeded the number of max attempts in the backoff: {}", (Object)backoff);
            return -1L;
        }
        nextDelay = Math.max(nextDelay, millisAfterFromServer);
        if (state.timeoutForWholeRetryEnabled() && nextDelay > state.actualResponseTimeoutMillis()) {
            return -1L;
        }
        return nextDelay;
    }

    protected static int getTotalAttempts(ClientRequestContext ctx) {
        State state = ctx.attr(STATE);
        if (state == null) {
            return 0;
        }
        return state.totalAttemptNo;
    }

    protected static ClientRequestContext newDerivedContext(ClientRequestContext ctx, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, boolean initialAttempt) {
        return ClientUtil.newDerivedContext(ctx, req, rpcReq, initialAttempt);
    }

    private static final class State {
        private final int maxTotalAttempts;
        private final long responseTimeoutMillisForEachAttempt;
        private final long deadlineNanos;
        private final boolean isTimeoutEnabled;
        @Nullable
        private Backoff lastBackoff;
        private int currentAttemptNoWithLastBackoff;
        private int totalAttemptNo;

        State(int maxTotalAttempts, long responseTimeoutMillisForEachAttempt, long responseTimeoutMillis) {
            this.maxTotalAttempts = maxTotalAttempts;
            this.responseTimeoutMillisForEachAttempt = responseTimeoutMillisForEachAttempt;
            if (responseTimeoutMillis <= 0L || responseTimeoutMillis == Long.MAX_VALUE) {
                this.deadlineNanos = 0L;
                this.isTimeoutEnabled = false;
            } else {
                this.deadlineNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(responseTimeoutMillis);
                this.isTimeoutEnabled = true;
            }
            this.totalAttemptNo = 1;
        }

        long responseTimeoutMillis() {
            if (!this.timeoutForWholeRetryEnabled()) {
                return this.responseTimeoutMillisForEachAttempt;
            }
            long actualResponseTimeoutMillis = this.actualResponseTimeoutMillis();
            if (actualResponseTimeoutMillis <= 0L) {
                return -1L;
            }
            if (this.responseTimeoutMillisForEachAttempt > 0L) {
                return Math.min(this.responseTimeoutMillisForEachAttempt, actualResponseTimeoutMillis);
            }
            return actualResponseTimeoutMillis;
        }

        boolean timeoutForWholeRetryEnabled() {
            return this.isTimeoutEnabled;
        }

        long actualResponseTimeoutMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.deadlineNanos - System.nanoTime());
        }

        int currentAttemptNoWith(Backoff backoff) {
            if (this.totalAttemptNo++ >= this.maxTotalAttempts) {
                return -1;
            }
            if (this.lastBackoff != backoff) {
                this.lastBackoff = backoff;
                this.currentAttemptNoWithLastBackoff = 1;
            }
            return this.currentAttemptNoWithLastBackoff++;
        }
    }
}

