/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.logging;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogLevelMapper;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.ResponseLogLevelMapper;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.internal.common.logging.LoggingDecorators;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLoggingClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private final RequestLogger requestLogger = new RequestLogger();
    private final ResponseLogger responseLogger = new ResponseLogger();
    private final Logger logger;
    private final RequestLogLevelMapper requestLogLevelMapper;
    private final ResponseLogLevelMapper responseLogLevelMapper;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestHeadersSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseHeadersSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer;
    private final BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer;
    private final Sampler<? super RequestLog> sampler;

    AbstractLoggingClient(Client<I, O> delegate, @Nullable Logger logger, RequestLogLevelMapper requestLogLevelMapper, ResponseLogLevelMapper responseLogLevelMapper, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestHeadersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseHeadersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer, BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer, Sampler<? super ClientRequestContext> successSampler, Sampler<? super ClientRequestContext> failureSampler) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.logger = logger != null ? logger : LoggerFactory.getLogger(this.getClass());
        this.requestLogLevelMapper = Objects.requireNonNull(requestLogLevelMapper, "requestLogLevelMapper");
        this.responseLogLevelMapper = Objects.requireNonNull(responseLogLevelMapper, "responseLogLevelMapper");
        this.requestHeadersSanitizer = Objects.requireNonNull(requestHeadersSanitizer, "requestHeadersSanitizer");
        this.requestContentSanitizer = Objects.requireNonNull(requestContentSanitizer, "requestContentSanitizer");
        this.requestTrailersSanitizer = Objects.requireNonNull(requestTrailersSanitizer, "requestTrailersSanitizer");
        this.responseHeadersSanitizer = Objects.requireNonNull(responseHeadersSanitizer, "responseHeadersSanitizer");
        this.responseContentSanitizer = Objects.requireNonNull(responseContentSanitizer, "responseContentSanitizer");
        this.responseTrailersSanitizer = Objects.requireNonNull(responseTrailersSanitizer, "responseTrailersSanitizer");
        this.responseCauseSanitizer = Objects.requireNonNull(responseCauseSanitizer, "responseCauseSanitizer");
        Objects.requireNonNull(successSampler, "successSampler");
        Objects.requireNonNull(failureSampler, "failureSampler");
        this.sampler = requestLog -> {
            ClientRequestContext ctx = (ClientRequestContext)requestLog.context();
            if (ctx.options().successFunction().isSuccess(ctx, (RequestLog)requestLog)) {
                return successSampler.isSampled(ctx);
            }
            return failureSampler.isSampled(ctx);
        };
    }

    @Override
    public final O execute(ClientRequestContext ctx, I req) throws Exception {
        ctx.log().whenComplete().thenAccept(log -> {
            if (this.sampler.isSampled((RequestLog)log)) {
                LoggingDecorators.log(this.logger, ctx, log, this.requestLogger, this.responseLogger);
            }
        });
        return ((Client)this.unwrap()).execute(ctx, req);
    }

    private class RequestLogger
    implements Consumer<RequestOnlyLog> {
        private RequestLogger() {
        }

        @Override
        public void accept(RequestOnlyLog log) {
            LoggingDecorators.logRequest(AbstractLoggingClient.this.logger, log, AbstractLoggingClient.this.requestLogLevelMapper, AbstractLoggingClient.this.requestHeadersSanitizer, AbstractLoggingClient.this.requestContentSanitizer, AbstractLoggingClient.this.requestTrailersSanitizer);
        }
    }

    private class ResponseLogger
    implements Consumer<RequestLog> {
        private ResponseLogger() {
        }

        @Override
        public void accept(RequestLog log) {
            LoggingDecorators.logResponse(AbstractLoggingClient.this.logger, log, AbstractLoggingClient.this.requestLogLevelMapper, AbstractLoggingClient.this.responseLogLevelMapper, AbstractLoggingClient.this.requestHeadersSanitizer, AbstractLoggingClient.this.requestContentSanitizer, AbstractLoggingClient.this.requestHeadersSanitizer, AbstractLoggingClient.this.responseHeadersSanitizer, AbstractLoggingClient.this.responseContentSanitizer, AbstractLoggingClient.this.responseTrailersSanitizer, AbstractLoggingClient.this.responseCauseSanitizer);
        }
    }
}

