/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.limit;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.limit.ConcurrencyLimitBuilder;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;

@FunctionalInterface
public interface ConcurrencyLimit {
    public static ConcurrencyLimit of(int maxConcurrency) {
        return ConcurrencyLimit.builder(maxConcurrency).build();
    }

    public static ConcurrencyLimit of(IntSupplier maxConcurrency) {
        return ConcurrencyLimit.builder(maxConcurrency).build();
    }

    public static ConcurrencyLimitBuilder builder(int maxConcurrency) {
        Preconditions.checkArgument(maxConcurrency >= 0, "maxConcurrency: %s (expected: >= 0)", maxConcurrency);
        return new ConcurrencyLimitBuilder(maxConcurrency == Integer.MAX_VALUE ? 0 : maxConcurrency);
    }

    public static ConcurrencyLimitBuilder builder(IntSupplier maxConcurrency) {
        Objects.requireNonNull(maxConcurrency, "maxConcurrency");
        return new ConcurrencyLimitBuilder(maxConcurrency);
    }

    public CompletableFuture<SafeCloseable> acquire(ClientRequestContext var1);
}

