/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.AbstractHealthCheckedEndpointGroupBuilder;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import com.linecorp.armeria.client.endpoint.healthcheck.HttpHealthChecker;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.util.AsyncCloseable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public final class HealthCheckedEndpointGroupBuilder
extends AbstractHealthCheckedEndpointGroupBuilder {
    private final String path;
    private boolean useGet;

    HealthCheckedEndpointGroupBuilder(EndpointGroup delegate, String path) {
        super(delegate);
        this.path = Objects.requireNonNull(path, "path");
    }

    public HealthCheckedEndpointGroupBuilder useGet(boolean useGet) {
        this.useGet = useGet;
        return this;
    }

    @Override
    public HealthCheckedEndpointGroupBuilder clientFactory(ClientFactory clientFactory) {
        return (HealthCheckedEndpointGroupBuilder)super.clientFactory(clientFactory);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder protocol(SessionProtocol protocol) {
        return (HealthCheckedEndpointGroupBuilder)super.protocol(protocol);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder port(int port) {
        return (HealthCheckedEndpointGroupBuilder)super.port(port);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder retryInterval(Duration retryInterval) {
        return (HealthCheckedEndpointGroupBuilder)super.retryInterval(retryInterval);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder retryIntervalMillis(long retryIntervalMillis) {
        return (HealthCheckedEndpointGroupBuilder)super.retryIntervalMillis(retryIntervalMillis);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder retryBackoff(Backoff retryBackoff) {
        return (HealthCheckedEndpointGroupBuilder)super.retryBackoff(retryBackoff);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder clientOptions(ClientOptions options) {
        return (HealthCheckedEndpointGroupBuilder)super.clientOptions(options);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder withClientOptions(Function<? super ClientOptionsBuilder, ClientOptionsBuilder> configurator) {
        return (HealthCheckedEndpointGroupBuilder)super.withClientOptions(configurator);
    }

    @Override
    protected Function<? super HealthCheckerContext, ? extends AsyncCloseable> newCheckerFactory() {
        return new HttpHealthCheckerFactory(this.path, this.useGet);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder maxEndpointRatio(double maxEndpointRatio) {
        return (HealthCheckedEndpointGroupBuilder)super.maxEndpointRatio(maxEndpointRatio);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder maxEndpointCount(int maxEndpointCount) {
        return (HealthCheckedEndpointGroupBuilder)super.maxEndpointCount(maxEndpointCount);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder auth(AuthToken token) {
        return (HealthCheckedEndpointGroupBuilder)super.auth(token);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder allowEmptyEndpoints(boolean allowEmptyEndpoints) {
        return (HealthCheckedEndpointGroupBuilder)super.allowEmptyEndpoints(allowEmptyEndpoints);
    }

    private static class HttpHealthCheckerFactory
    implements Function<HealthCheckerContext, AsyncCloseable> {
        private final String path;
        private final boolean useGet;

        HttpHealthCheckerFactory(String path, boolean useGet) {
            this.path = path;
            this.useGet = useGet;
        }

        @Override
        public AsyncCloseable apply(HealthCheckerContext ctx) {
            HttpHealthChecker checker = new HttpHealthChecker(ctx, this.path, this.useGet);
            checker.start();
            return checker;
        }
    }
}

