/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.healthcheck.DefaultHealthCheckerContext;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.AsyncCloseable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

final class HealthCheckContextGroup {
    private static final CompletableFuture<?>[] EMPTY_FUTURES = new CompletableFuture[0];
    private final Map<Endpoint, DefaultHealthCheckerContext> contexts;
    private final List<Endpoint> candidates;
    private final Function<? super HealthCheckerContext, ? extends AsyncCloseable> checkerFactory;
    @Nullable
    private CompletableFuture<?> initFutures;

    HealthCheckContextGroup(Map<Endpoint, DefaultHealthCheckerContext> contexts, List<Endpoint> candidates, Function<? super HealthCheckerContext, ? extends AsyncCloseable> checkerFactory) {
        this.contexts = Collections.unmodifiableMap(contexts);
        this.candidates = candidates;
        this.checkerFactory = checkerFactory;
    }

    Map<Endpoint, DefaultHealthCheckerContext> contexts() {
        return this.contexts;
    }

    List<Endpoint> candidates() {
        return this.candidates;
    }

    void initialize() {
        List futures = this.contexts.values().stream().peek(context -> {
            if (!context.isInitialized()) {
                context.init(this.checkerFactory.apply((HealthCheckerContext)context));
            }
        }).map(DefaultHealthCheckerContext::whenInitialized).collect(ImmutableList.toImmutableList());
        this.initFutures = CompletableFuture.allOf(futures.toArray(EMPTY_FUTURES)).handle((unused, cause) -> {
            if (cause == null) {
                return null;
            }
            if (futures.isEmpty()) {
                return null;
            }
            if (futures.stream().anyMatch(future -> !future.isCompletedExceptionally())) {
                return null;
            }
            Throwable combined = null;
            for (CompletableFuture future2 : futures) {
                try {
                    future2.join();
                }
                catch (Throwable ex) {
                    if (combined == null) {
                        combined = ex;
                        continue;
                    }
                    combined.addSuppressed(Exceptions.peel(ex));
                }
            }
            assert (combined != null);
            return Exceptions.throwUnsafely(combined);
        });
    }

    CompletableFuture<?> whenInitialized() {
        assert (this.initFutures != null) : "Should call initialize() before invoking this method.";
        return this.initFutures;
    }
}

