/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.endpoint.AbstractDynamicEndpointGroupBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckStrategy;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.util.AsyncCloseable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractHealthCheckedEndpointGroupBuilder
extends AbstractDynamicEndpointGroupBuilder {
    static final Backoff DEFAULT_HEALTH_CHECK_RETRY_BACKOFF = Backoff.fixed(3000L).withJitter(0.2);
    private final EndpointGroup delegate;
    private SessionProtocol protocol = SessionProtocol.HTTP;
    private Backoff retryBackoff = DEFAULT_HEALTH_CHECK_RETRY_BACKOFF;
    private ClientOptionsBuilder clientOptionsBuilder = ClientOptions.builder();
    private int port;
    @Nullable
    private Double maxEndpointRatio;
    @Nullable
    private Integer maxEndpointCount;

    protected AbstractHealthCheckedEndpointGroupBuilder(EndpointGroup delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public AbstractHealthCheckedEndpointGroupBuilder clientFactory(ClientFactory clientFactory) {
        this.clientOptionsBuilder.factory(Objects.requireNonNull(clientFactory, "clientFactory"));
        return this;
    }

    public AbstractHealthCheckedEndpointGroupBuilder protocol(SessionProtocol protocol) {
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        return this;
    }

    public AbstractHealthCheckedEndpointGroupBuilder port(int port) {
        Preconditions.checkArgument(port > 0 && port <= 65535, "port: %s (expected: 1-65535)", port);
        this.port = port;
        return this;
    }

    public AbstractHealthCheckedEndpointGroupBuilder retryInterval(Duration retryInterval) {
        Objects.requireNonNull(retryInterval, "retryInterval");
        Preconditions.checkArgument(!retryInterval.isNegative() && !retryInterval.isZero(), "retryInterval: %s (expected: > 0)", (Object)retryInterval);
        return this.retryIntervalMillis(retryInterval.toMillis());
    }

    public AbstractHealthCheckedEndpointGroupBuilder retryIntervalMillis(long retryIntervalMillis) {
        Preconditions.checkArgument(retryIntervalMillis > 0L, "retryIntervalMillis: %s (expected: > 0)", retryIntervalMillis);
        return this.retryBackoff(Backoff.fixed(retryIntervalMillis).withJitter(0.2));
    }

    public AbstractHealthCheckedEndpointGroupBuilder retryBackoff(Backoff retryBackoff) {
        this.retryBackoff = Objects.requireNonNull(retryBackoff, "retryBackoff");
        return this;
    }

    public AbstractHealthCheckedEndpointGroupBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptionsBuilder.options(Objects.requireNonNull(clientOptions, "clientOptions"));
        return this;
    }

    public AbstractHealthCheckedEndpointGroupBuilder withClientOptions(Function<? super ClientOptionsBuilder, ClientOptionsBuilder> configurator) {
        ClientOptionsBuilder newBuilder = Objects.requireNonNull(configurator, "configurator").apply(this.clientOptionsBuilder);
        Preconditions.checkState(newBuilder != null, "configurator returned null.");
        this.clientOptionsBuilder = newBuilder;
        return this;
    }

    public AbstractHealthCheckedEndpointGroupBuilder maxEndpointRatio(double maxEndpointRatio) {
        if (this.maxEndpointCount != null) {
            throw new IllegalArgumentException("Maximum endpoint count is already set.");
        }
        Preconditions.checkArgument(maxEndpointRatio > 0.0 && maxEndpointRatio <= 1.0, "maxEndpointRatio: %s (expected: 0.0 < maxEndpointRatio <= 1.0)", (Object)maxEndpointRatio);
        this.maxEndpointRatio = maxEndpointRatio;
        return this;
    }

    public AbstractHealthCheckedEndpointGroupBuilder maxEndpointCount(int maxEndpointCount) {
        if (this.maxEndpointRatio != null) {
            throw new IllegalArgumentException("Maximum endpoint ratio is already set.");
        }
        Preconditions.checkArgument(maxEndpointCount > 0, "maxEndpointCount: %s (expected: > 0)", maxEndpointCount);
        this.maxEndpointCount = maxEndpointCount;
        return this;
    }

    public AbstractHealthCheckedEndpointGroupBuilder auth(AuthToken token) {
        Objects.requireNonNull(token, "token");
        this.clientOptionsBuilder.auth(token);
        return this;
    }

    @Override
    public AbstractHealthCheckedEndpointGroupBuilder allowEmptyEndpoints(boolean allowEmptyEndpoints) {
        return (AbstractHealthCheckedEndpointGroupBuilder)super.allowEmptyEndpoints(allowEmptyEndpoints);
    }

    public final HealthCheckedEndpointGroup build() {
        HealthCheckStrategy healthCheckStrategy = this.maxEndpointCount != null ? HealthCheckStrategy.ofCount(this.maxEndpointCount) : (this.maxEndpointRatio == null || this.maxEndpointRatio == 1.0 ? HealthCheckStrategy.all() : HealthCheckStrategy.ofRatio(this.maxEndpointRatio));
        return new HealthCheckedEndpointGroup(this.delegate, this.shouldAllowEmptyEndpoints(), this.protocol, this.port, this.retryBackoff, this.clientOptionsBuilder.build(), this.newCheckerFactory(), healthCheckStrategy);
    }

    protected abstract Function<? super HealthCheckerContext, ? extends AsyncCloseable> newCheckerFactory();
}

