/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.dns;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.dns.DnsEndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsTextEndpointGroupBuilder;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.client.dns.ByteArrayDnsRecord;
import com.linecorp.armeria.internal.client.dns.DefaultDnsResolver;
import com.linecorp.armeria.internal.client.dns.DnsQuestionWithoutTrailingDot;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import java.util.List;
import java.util.function.Function;

public final class DnsTextEndpointGroup
extends DnsEndpointGroup {
    private final Function<byte[], @Nullable Endpoint> mapping;

    public static DnsTextEndpointGroup of(String hostname, Function<byte[], @Nullable Endpoint> mapping) {
        return DnsTextEndpointGroup.builder(hostname, mapping).build();
    }

    public static DnsTextEndpointGroupBuilder builder(String hostname, Function<byte[], @Nullable Endpoint> mapping) {
        return new DnsTextEndpointGroupBuilder(hostname, mapping);
    }

    DnsTextEndpointGroup(EndpointSelectionStrategy selectionStrategy, boolean allowEmptyEndpoints, DefaultDnsResolver resolver, EventLoop eventLoop, Backoff backoff, int minTtl, int maxTtl, String hostname, Function<byte[], @Nullable Endpoint> mapping) {
        super(selectionStrategy, allowEmptyEndpoints, resolver, eventLoop, ImmutableList.of(DnsQuestionWithoutTrailingDot.of(hostname, DnsRecordType.TXT)), backoff, minTtl, maxTtl);
        this.mapping = mapping;
        this.start();
    }

    @Override
    ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> records, int ttl) throws Exception {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (DnsRecord r : records) {
            Endpoint endpoint;
            if (!(r instanceof ByteArrayDnsRecord) || r.type() != DnsRecordType.TXT) continue;
            byte[] content = ((ByteArrayDnsRecord)r).content();
            if (content.length == 0) {
                this.warnInvalidRecord(DnsRecordType.TXT, content);
                continue;
            }
            int txtLen = content[0] & 0xFF;
            if (txtLen == 0) continue;
            if (content.length != txtLen + 1) {
                this.warnInvalidRecord(DnsRecordType.TXT, content);
                continue;
            }
            byte[] txt = new byte[txtLen];
            System.arraycopy(content, 1, txt, 0, txtLen);
            try {
                endpoint = this.mapping.apply(txt);
            }
            catch (Exception e) {
                this.warnInvalidRecord(DnsRecordType.TXT, content);
                continue;
            }
            if (endpoint == null) continue;
            builder.add(endpoint);
        }
        ImmutableSet endpoints = builder.build();
        this.logDnsResolutionResult(endpoints, ttl);
        return endpoints;
    }
}

