/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.dns;

import com.linecorp.armeria.client.AbstractDnsResolverBuilder;
import com.linecorp.armeria.client.endpoint.AbstractDynamicEndpointGroupBuilder;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroupSetters;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.TransportType;
import com.linecorp.armeria.internal.client.dns.DefaultDnsResolver;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.util.concurrent.EventExecutor;
import java.net.IDN;
import java.util.Objects;
import java.util.function.Consumer;

abstract class DnsEndpointGroupBuilder
extends AbstractDnsResolverBuilder
implements DynamicEndpointGroupSetters {
    private final String hostname;
    @Nullable
    private EventLoop eventLoop;
    private Backoff backoff = Backoff.exponential(1000L, 32000L).withJitter(0.2);
    private EndpointSelectionStrategy selectionStrategy = EndpointSelectionStrategy.weightedRoundRobin();
    private final DnsDynamicEndpointGroupBuilder dnsDynamicEndpointGroupBuilder = new DnsDynamicEndpointGroupBuilder();

    DnsEndpointGroupBuilder(String hostname) {
        this.hostname = Ascii.toLowerCase(IDN.toASCII(Objects.requireNonNull(hostname, "hostname"), 1));
    }

    final String hostname() {
        return this.hostname;
    }

    final EventLoop eventLoop() {
        if (this.eventLoop != null) {
            return this.eventLoop;
        }
        return CommonPools.workerGroup().next();
    }

    public DnsEndpointGroupBuilder eventLoop(EventLoop eventLoop) {
        Objects.requireNonNull(eventLoop, "eventLoop");
        Preconditions.checkArgument(TransportType.isSupported((EventLoopGroup)eventLoop), "unsupported event loop type: %s", (Object)eventLoop);
        this.eventLoop = eventLoop;
        return this;
    }

    final Backoff backoff() {
        return this.backoff;
    }

    public DnsEndpointGroupBuilder backoff(Backoff backoff) {
        this.backoff = Objects.requireNonNull(backoff, "backoff");
        return this;
    }

    public DnsEndpointGroupBuilder selectionStrategy(EndpointSelectionStrategy selectionStrategy) {
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        return this;
    }

    final EndpointSelectionStrategy selectionStrategy() {
        return this.selectionStrategy;
    }

    final boolean shouldAllowEmptyEndpoints() {
        return this.dnsDynamicEndpointGroupBuilder.shouldAllowEmptyEndpoints();
    }

    @Override
    public DnsEndpointGroupBuilder allowEmptyEndpoints(boolean allowEmptyEndpoints) {
        this.dnsDynamicEndpointGroupBuilder.allowEmptyEndpoints(allowEmptyEndpoints);
        return this;
    }

    final DefaultDnsResolver buildResolver() {
        return this.buildResolver(unused -> {});
    }

    final DefaultDnsResolver buildResolver(Consumer<DnsNameResolverBuilder> customizer) {
        EventLoop eventLoop = this.eventLoop();
        DnsNameResolverBuilder resolverBuilder = new DnsNameResolverBuilder(eventLoop);
        customizer.accept(resolverBuilder);
        this.buildConfigurator(eventLoop.parent()).accept(resolverBuilder);
        return DefaultDnsResolver.of(resolverBuilder.build(), this.maybeCreateDnsCache(), (EventExecutor)eventLoop, this.searchDomains(), this.ndots(), this.queryTimeoutMillis(), this.hostsFileEntriesResolver());
    }

    private static class DnsDynamicEndpointGroupBuilder
    extends AbstractDynamicEndpointGroupBuilder {
        private DnsDynamicEndpointGroupBuilder() {
        }

        @Override
        public boolean shouldAllowEmptyEndpoints() {
            return super.shouldAllowEmptyEndpoints();
        }
    }
}

