/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.AbstractEndpointSelector;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.internal.shaded.guava.hash.Hashing;
import java.util.List;
import java.util.Objects;
import java.util.function.ToLongFunction;

final class StickyEndpointSelectionStrategy
implements EndpointSelectionStrategy {
    private final ToLongFunction<? super ClientRequestContext> requestContextHasher;

    StickyEndpointSelectionStrategy(ToLongFunction<? super ClientRequestContext> requestContextHasher) {
        this.requestContextHasher = Objects.requireNonNull(requestContextHasher, "requestContextHasher");
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new StickyEndpointSelector(endpointGroup, this.requestContextHasher);
    }

    private static final class StickyEndpointSelector
    extends AbstractEndpointSelector {
        private final ToLongFunction<? super ClientRequestContext> requestContextHasher;

        StickyEndpointSelector(EndpointGroup endpointGroup, ToLongFunction<? super ClientRequestContext> requestContextHasher) {
            super(endpointGroup);
            this.requestContextHasher = Objects.requireNonNull(requestContextHasher, "requestContextHasher");
        }

        @Override
        public Endpoint selectNow(ClientRequestContext ctx) {
            List<Endpoint> endpoints = this.group().endpoints();
            if (endpoints.isEmpty()) {
                return null;
            }
            long key = this.requestContextHasher.applyAsLong(ctx);
            int nearest = Hashing.consistentHash(key, endpoints.size());
            return endpoints.get(nearest);
        }
    }
}

