/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.function.Supplier;

final class RestartableThread {
    @Nullable
    private Thread thread;
    private final Supplier<Runnable> runnableSupplier;
    private final String name;

    RestartableThread(String name, Supplier<Runnable> runnableSupplier) {
        this.name = name;
        this.runnableSupplier = runnableSupplier;
    }

    synchronized void start() {
        if (!this.isRunning()) {
            Preconditions.checkState(this.thread == null, "trying to start thread without cleanup");
            this.thread = new Thread(this.runnableSupplier.get(), this.name);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    synchronized void stop() {
        if (this.isRunning()) {
            Preconditions.checkState(this.thread != null, "tried to stop null thread");
            boolean interrupted = false;
            this.thread.interrupt();
            while (this.thread.isAlive()) {
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.thread = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }
}

