/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.AbstractEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.common.util.AsyncCloseableSupport;
import com.linecorp.armeria.common.util.ListenableAsyncCloseable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;

final class OrElseEndpointGroup
extends AbstractEndpointGroup
implements ListenableAsyncCloseable {
    private final EndpointGroup first;
    private final EndpointGroup second;
    private final CompletableFuture<List<Endpoint>> initialEndpointsFuture;
    private final EndpointSelector selector;
    private final AsyncCloseableSupport closeable = AsyncCloseableSupport.of(this::closeAsync);

    OrElseEndpointGroup(EndpointGroup first, EndpointGroup second) {
        this.first = Objects.requireNonNull(first, "first");
        this.second = Objects.requireNonNull(second, "second");
        first.addListener((Consumer<? super List<Endpoint>>)((Consumer<List>)unused -> this.notifyListeners(this.endpoints())));
        second.addListener((Consumer<? super List<Endpoint>>)((Consumer<List>)unused -> this.notifyListeners(this.endpoints())));
        this.initialEndpointsFuture = CompletableFuture.anyOf(first.whenReady(), second.whenReady()).thenApply(unused -> this.endpoints());
        this.selector = first.selectionStrategy().newSelector(this);
    }

    @Override
    public List<Endpoint> endpoints() {
        List<Endpoint> endpoints = this.first.endpoints();
        if (!endpoints.isEmpty()) {
            return endpoints;
        }
        return this.second.endpoints();
    }

    @Override
    public EndpointSelectionStrategy selectionStrategy() {
        return this.first.selectionStrategy();
    }

    @Override
    public Endpoint selectNow(ClientRequestContext ctx) {
        return this.selector.selectNow(ctx);
    }

    @Override
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.selector.select(ctx, executor, timeoutMillis);
    }

    @Override
    public CompletableFuture<List<Endpoint>> whenReady() {
        return this.initialEndpointsFuture;
    }

    @Override
    public boolean isClosing() {
        return this.closeable.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.closeable.isClosed();
    }

    @Override
    public CompletableFuture<?> whenClosed() {
        return this.closeable.whenClosed();
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return this.closeable.closeAsync();
    }

    private void closeAsync(CompletableFuture<?> future) {
        CompletableFuture.allOf(this.first.closeAsync(), this.second.closeAsync()).handle((unused, cause) -> {
            if (cause != null) {
                future.completeExceptionally((Throwable)cause);
            } else {
                future.complete(null);
            }
            return null;
        });
    }

    @Override
    public void close() {
        this.closeable.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("first", this.first).add("second", this.second).add("initialized", this.initialEndpointsFuture.isDone()).toString();
    }
}

