/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.AbstractEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.common.util.AsyncCloseable;
import com.linecorp.armeria.common.util.AsyncCloseableSupport;
import com.linecorp.armeria.common.util.ListenableAsyncCloseable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

final class CompositeEndpointGroup
extends AbstractEndpointGroup
implements ListenableAsyncCloseable {
    private final List<EndpointGroup> endpointGroups;
    private final CompletableFuture<List<Endpoint>> initialEndpointsFuture;
    private final AtomicBoolean dirty;
    private final EndpointSelectionStrategy selectionStrategy;
    private final EndpointSelector selector;
    private final AsyncCloseableSupport closeable = AsyncCloseableSupport.of(this::closeAsync);
    private volatile List<Endpoint> merged = ImmutableList.of();

    CompositeEndpointGroup(EndpointSelectionStrategy selectionStrategy, Iterable<EndpointGroup> endpointGroups) {
        this.endpointGroups = ImmutableList.copyOf(Objects.requireNonNull(endpointGroups, "endpointGroups"));
        this.dirty = new AtomicBoolean(true);
        for (EndpointGroup endpointGroup : endpointGroups) {
            endpointGroup.addListener((Consumer<? super List<Endpoint>>)((Consumer<List>)unused -> {
                this.dirty.set(true);
                this.notifyListeners(this.endpoints());
            }));
        }
        this.initialEndpointsFuture = CompletableFuture.anyOf((CompletableFuture[])this.endpointGroups.stream().map(EndpointGroup::whenReady).toArray(CompletableFuture[]::new)).thenApply(unused -> this.endpoints());
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        this.selector = Objects.requireNonNull(selectionStrategy, "selectionStrategy").newSelector(this);
    }

    @Override
    public List<Endpoint> endpoints() {
        if (!this.dirty.get()) {
            return this.merged;
        }
        if (!this.dirty.compareAndSet(true, false)) {
            return this.merged;
        }
        ImmutableList.Builder newEndpoints = ImmutableList.builder();
        for (EndpointGroup endpointGroup : this.endpointGroups) {
            newEndpoints.addAll(endpointGroup.endpoints());
        }
        this.merged = newEndpoints.build();
        return this.merged;
    }

    @Override
    public EndpointSelectionStrategy selectionStrategy() {
        return this.selectionStrategy;
    }

    @Override
    public Endpoint selectNow(ClientRequestContext ctx) {
        return this.selector.selectNow(ctx);
    }

    @Override
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.selector.select(ctx, executor, timeoutMillis);
    }

    @Override
    public CompletableFuture<List<Endpoint>> whenReady() {
        return this.initialEndpointsFuture;
    }

    @Override
    public boolean isClosing() {
        return this.closeable.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.closeable.isClosed();
    }

    @Override
    public CompletableFuture<?> whenClosed() {
        return this.closeable.whenClosed();
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return this.closeable.closeAsync();
    }

    private void closeAsync(CompletableFuture<?> future) {
        CompletableFuture[] closeFutures = (CompletableFuture[])this.endpointGroups.stream().map(AsyncCloseable::closeAsync).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(closeFutures).handle((unused, cause) -> {
            if (cause != null) {
                future.completeExceptionally((Throwable)cause);
            } else {
                future.complete(null);
            }
            return null;
        });
    }

    @Override
    public void close() {
        this.closeable.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("endpointGroups", this.endpointGroups).toString();
    }
}

