/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class AbstractEndpointSelector
implements EndpointSelector {
    private final EndpointGroup endpointGroup;

    protected AbstractEndpointSelector(EndpointGroup endpointGroup) {
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
    }

    protected final EndpointGroup group() {
        return this.endpointGroup;
    }

    @Override
    public final CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        Endpoint endpoint = this.selectNow(ctx);
        if (endpoint != null) {
            return UnmodifiableFuture.completedFuture(endpoint);
        }
        ListeningFuture listeningFuture = new ListeningFuture(ctx, executor);
        this.endpointGroup.addListener(listeningFuture);
        endpoint = this.selectNow(ctx);
        if (endpoint != null) {
            this.endpointGroup.removeListener(listeningFuture);
            return UnmodifiableFuture.completedFuture(endpoint);
        }
        ScheduledFuture<Boolean> timeoutFuture = executor.schedule(() -> listeningFuture.complete(null), timeoutMillis, TimeUnit.MILLISECONDS);
        listeningFuture.timeoutFuture = timeoutFuture;
        if (listeningFuture.isDone()) {
            timeoutFuture.cancel(false);
        }
        return listeningFuture;
    }

    private class ListeningFuture
    extends CompletableFuture<Endpoint>
    implements Consumer<List<Endpoint>> {
        private final ClientRequestContext ctx;
        private final Executor executor;
        @Nullable
        private volatile Endpoint selectedEndpoint;
        @Nullable
        private volatile ScheduledFuture<?> timeoutFuture;

        ListeningFuture(ClientRequestContext ctx, Executor executor) {
            this.ctx = ctx;
            this.executor = executor;
        }

        @Override
        public void accept(List<Endpoint> unused) {
            if (this.selectedEndpoint != null || this.isDone()) {
                return;
            }
            try {
                Endpoint endpoint = AbstractEndpointSelector.this.selectNow(this.ctx);
                if (endpoint != null) {
                    this.cleanup();
                    this.selectedEndpoint = endpoint;
                    this.executor.execute(() -> super.complete(endpoint));
                }
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cleanup();
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean complete(Endpoint value) {
            this.cleanup();
            return super.complete(value);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            this.cleanup();
            return super.completeExceptionally(ex);
        }

        private void cleanup() {
            AbstractEndpointSelector.this.group().removeListener(this);
            ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
            if (timeoutFuture != null) {
                this.timeoutFuture = null;
                timeoutFuture.cancel(false);
            }
        }
    }
}

