/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.cookie;

import com.linecorp.armeria.client.cookie.CookieJar;
import com.linecorp.armeria.client.cookie.CookiePolicy;
import com.linecorp.armeria.client.cookie.CookieState;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.CookieBuilder;
import com.linecorp.armeria.common.Cookies;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2LongOpenHashMap;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import io.netty.util.NetUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

final class DefaultCookieJar
implements CookieJar {
    private final Object2LongOpenHashMap<Cookie> store;
    private final Map<String, Set<Cookie>> filter;
    private final CookiePolicy cookiePolicy;
    private final ReentrantLock lock;

    DefaultCookieJar() {
        this(CookiePolicy.acceptOriginOnly());
    }

    DefaultCookieJar(CookiePolicy cookiePolicy) {
        this.cookiePolicy = cookiePolicy;
        this.store = new Object2LongOpenHashMap();
        this.filter = new HashMap<String, Set<Cookie>>();
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cookies get(URI uri) {
        Objects.requireNonNull(uri, "uri");
        if (this.store.isEmpty()) {
            return Cookies.of();
        }
        String host = uri.getHost();
        String path = uri.getPath().isEmpty() ? "/" : uri.getPath();
        boolean secure = DefaultCookieJar.isSecure(uri.getScheme());
        HashSet<Cookie> cookies = new HashSet<Cookie>();
        this.lock.lock();
        try {
            this.filterGet(cookies, host, path, secure);
        }
        finally {
            this.lock.unlock();
        }
        return Cookies.of(cookies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(URI uri, Iterable<? extends Cookie> cookies, long createdTimeMillis) {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(cookies, "cookies");
        this.lock.lock();
        try {
            for (Cookie cookie : cookies) {
                Cookie cookie2 = this.ensureDomainAndPath(cookie, uri);
                this.store.removeLong(cookie2);
                if (cookie2.maxAge() != Long.MIN_VALUE && cookie2.maxAge() <= 0L || !this.cookiePolicy.accept(uri, cookie2)) continue;
                this.store.put(cookie2, createdTimeMillis);
                Set cookieSet = this.filter.computeIfAbsent(cookie2.domain(), s -> new HashSet());
                cookieSet.remove(cookie2);
                cookieSet.add(cookie2);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public CookieState state(Cookie cookie, long currentTimeMillis) {
        Objects.requireNonNull(cookie, "cookie");
        this.lock.lock();
        long createdTimeMillis = this.store.getOrDefault((Object)cookie, Long.MIN_VALUE);
        this.lock.unlock();
        if (createdTimeMillis == Long.MIN_VALUE) {
            return CookieState.NON_EXISTENT;
        }
        return DefaultCookieJar.isExpired(cookie, createdTimeMillis, currentTimeMillis) ? CookieState.EXPIRED : CookieState.EXISTENT;
    }

    Cookie ensureDomainAndPath(Cookie cookie, URI uri) {
        boolean validPath;
        boolean validDomain = !Strings.isNullOrEmpty(cookie.domain());
        String cookiePath = cookie.path();
        boolean bl = validPath = !Strings.isNullOrEmpty(cookiePath) && cookiePath.charAt(0) == '/';
        if (validDomain && validPath) {
            return cookie;
        }
        CookieBuilder cb = cookie.toBuilder();
        if (!validDomain) {
            cb.domain(uri.getHost()).hostOnly(true);
        }
        if (!validPath) {
            String path = uri.getPath();
            if (path.isEmpty()) {
                path = "/";
            } else {
                int i = path.lastIndexOf(47);
                if (i > 0) {
                    path = path.substring(0, i);
                }
            }
            cb.path(path);
        }
        return cb.build();
    }

    private void filterGet(Set<Cookie> cookies, String host, String path, boolean secure) {
        long currentTimeMillis = System.currentTimeMillis();
        block0: for (Map.Entry<String, Set<Cookie>> entry : this.filter.entrySet()) {
            if (!DefaultCookieJar.domainMatches(entry.getKey(), host)) continue;
            Iterator<Cookie> it = entry.getValue().iterator();
            while (it.hasNext()) {
                Cookie cookie = it.next();
                long createdTimeMillis = this.store.getOrDefault((Object)cookie, Long.MIN_VALUE);
                if (createdTimeMillis == Long.MIN_VALUE) {
                    it.remove();
                    continue block0;
                }
                if (DefaultCookieJar.isExpired(cookie, createdTimeMillis, currentTimeMillis)) {
                    it.remove();
                    this.store.removeLong(cookie);
                    continue block0;
                }
                if (!DefaultCookieJar.cookieMatches(cookie, host, path, secure)) continue;
                cookies.add(cookie);
            }
        }
    }

    private static boolean isSecure(String scheme) {
        Scheme parsedScheme;
        SessionProtocol parsedProtocol = scheme.indexOf(43) >= 0 ? ((parsedScheme = Scheme.tryParse(scheme)) != null ? parsedScheme.sessionProtocol() : null) : SessionProtocol.find(scheme);
        return parsedProtocol != null && parsedProtocol.isTls();
    }

    private static boolean isExpired(Cookie cookie, long createdTimeMillis, long currentTimeMillis) {
        long timePassed = currentTimeMillis - createdTimeMillis;
        return cookie.maxAge() != Long.MIN_VALUE && timePassed > cookie.maxAge() * 1000L;
    }

    private static boolean domainMatches(String domain, String host) {
        if (domain.equalsIgnoreCase(host)) {
            return true;
        }
        return host.endsWith(domain) && host.charAt(host.length() - domain.length() - 1) == '.' && !NetUtil.isValidIpV4Address((String)host) && !NetUtil.isValidIpV6Address((String)host);
    }

    private static boolean cookieMatches(Cookie cookie, String host, String path, boolean secure) {
        boolean satisfiedHostOnly = !cookie.isHostOnly() || host.equalsIgnoreCase(cookie.domain());
        boolean satisfiedSecure = secure || !cookie.isSecure();
        String cookiePath = cookie.path();
        assert (cookiePath != null);
        boolean pathMatched = path.startsWith(cookiePath);
        return satisfiedHostOnly && satisfiedSecure && pathMatched;
    }
}

