/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerDecision;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerMapping;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRule;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRuleUtil;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRuleWithContent;
import com.linecorp.armeria.client.circuitbreaker.FailFastException;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCircuitBreakerClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCircuitBreakerClient.class);
    @Nullable
    private final CircuitBreakerRule rule;
    @Nullable
    private final CircuitBreakerRule fromRuleWithContent;
    @Nullable
    private final CircuitBreakerRuleWithContent<O> ruleWithContent;
    private final CircuitBreakerMapping mapping;

    AbstractCircuitBreakerClient(Client<I, O> delegate, CircuitBreakerMapping mapping, CircuitBreakerRule rule) {
        this(delegate, mapping, Objects.requireNonNull(rule, "rule"), null);
    }

    AbstractCircuitBreakerClient(Client<I, O> delegate, CircuitBreakerMapping mapping, CircuitBreakerRuleWithContent<O> ruleWithContent) {
        this(delegate, mapping, null, Objects.requireNonNull(ruleWithContent, "ruleWithContent"));
    }

    private AbstractCircuitBreakerClient(Client<I, O> delegate, CircuitBreakerMapping mapping, @Nullable CircuitBreakerRule rule, @Nullable CircuitBreakerRuleWithContent<O> ruleWithContent) {
        super(delegate);
        this.mapping = Objects.requireNonNull(mapping, "mapping");
        this.rule = rule;
        this.ruleWithContent = ruleWithContent;
        this.fromRuleWithContent = ruleWithContent != null ? CircuitBreakerRuleUtil.fromCircuitBreakerRuleWithContent(ruleWithContent) : null;
    }

    final CircuitBreakerRule rule() {
        Preconditions.checkState(this.rule != null, "rule is not set.");
        return this.rule;
    }

    final CircuitBreakerRuleWithContent<O> ruleWithContent() {
        Preconditions.checkState(this.ruleWithContent != null, "ruleWithContent is not set.");
        return this.ruleWithContent;
    }

    final CircuitBreakerRule fromRuleWithContent() {
        Preconditions.checkState(this.ruleWithContent != null, "ruleWithContent is not set.");
        return this.fromRuleWithContent;
    }

    @Override
    public final O execute(ClientRequestContext ctx, I req) throws Exception {
        CircuitBreaker circuitBreaker;
        try {
            circuitBreaker = this.mapping.get(ctx, (Request)req);
        }
        catch (Throwable t) {
            logger.warn("Failed to get a circuit breaker from mapping", t);
            return ((Client)this.unwrap()).execute(ctx, req);
        }
        if (circuitBreaker.tryRequest()) {
            return this.doExecute(ctx, req, circuitBreaker);
        }
        throw new FailFastException(circuitBreaker);
    }

    protected abstract O doExecute(ClientRequestContext var1, I var2, CircuitBreaker var3) throws Exception;

    protected static void reportSuccessOrFailure(CircuitBreaker circuitBreaker, CompletionStage<CircuitBreakerDecision> future) {
        future.handle((decision, unused) -> {
            if (decision != null) {
                if (decision == CircuitBreakerDecision.success() || decision == CircuitBreakerDecision.next()) {
                    circuitBreaker.onSuccess();
                } else if (decision == CircuitBreakerDecision.failure()) {
                    circuitBreaker.onFailure();
                }
            }
            return null;
        }).exceptionally(CompletionActions::log);
    }
}

