/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.DefaultClientRequestContext;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.AbstractUnwrappable;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.client.ClientUtil;
import io.micrometer.core.instrument.MeterRegistry;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserClient<I extends Request, O extends Response>
extends AbstractUnwrappable<Client<I, O>>
implements ClientBuilderParams {
    private static final Logger logger = LoggerFactory.getLogger(UserClient.class);
    private static boolean warnedNullRequestId;
    private final ClientBuilderParams params;
    private final MeterRegistry meterRegistry;
    private final Function<CompletableFuture<O>, O> futureConverter;
    private final BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory;

    protected UserClient(ClientBuilderParams params, Client<I, O> delegate, MeterRegistry meterRegistry, Function<CompletableFuture<O>, O> futureConverter, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory) {
        super(delegate);
        this.params = params;
        this.meterRegistry = meterRegistry;
        this.futureConverter = futureConverter;
        this.errorResponseFactory = errorResponseFactory;
    }

    @Override
    public final Scheme scheme() {
        return this.params.scheme();
    }

    @Override
    public final EndpointGroup endpointGroup() {
        return this.params.endpointGroup();
    }

    @Override
    public final String absolutePathRef() {
        return this.params.absolutePathRef();
    }

    @Override
    public final URI uri() {
        return this.params.uri();
    }

    @Override
    public final Class<?> clientType() {
        return this.params.clientType();
    }

    @Override
    public final ClientOptions options() {
        return this.params.options();
    }

    protected final O execute(SessionProtocol protocol, HttpMethod method, String path, @Nullable String query, @Nullable String fragment, I req) {
        return this.execute(protocol, this.endpointGroup(), method, path, query, fragment, req, RequestOptions.of());
    }

    protected final O execute(SessionProtocol protocol, EndpointGroup endpointGroup, HttpMethod method, String path, @Nullable String query, @Nullable String fragment, I req) {
        return this.execute(protocol, endpointGroup, method, path, query, fragment, req, RequestOptions.of());
    }

    protected final O execute(SessionProtocol protocol, EndpointGroup endpointGroup, HttpMethod method, String path, @Nullable String query, @Nullable String fragment, I req, RequestOptions requestOptions) {
        RpcRequest rpcReq;
        HttpRequest httpReq;
        RequestId id = this.nextRequestId();
        if (req instanceof HttpRequest) {
            httpReq = (HttpRequest)req;
            rpcReq = null;
        } else {
            httpReq = null;
            rpcReq = (RpcRequest)req;
        }
        boolean hasBaseUri = !Clients.isUndefinedUri(this.params.uri());
        DefaultClientRequestContext ctx = new DefaultClientRequestContext(this.meterRegistry, protocol, id, method, path, query, fragment, this.options(), httpReq, rpcReq, requestOptions, System.nanoTime(), SystemInfo.currentTimeMicros(), hasBaseUri);
        return ClientUtil.initContextAndExecuteWithFallback((Client)this.unwrap(), ctx, endpointGroup, this.futureConverter, this.errorResponseFactory);
    }

    private RequestId nextRequestId() {
        RequestId id = this.options().requestIdGenerator().get();
        if (id == null) {
            if (!warnedNullRequestId) {
                warnedNullRequestId = true;
                logger.warn("requestIdGenerator.get() returned null; using RequestId.random()");
            }
            return RequestId.random();
        }
        return id;
    }
}

