/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.LruMap;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionProtocolNegotiationCache {
    private static final Logger logger = LoggerFactory.getLogger(SessionProtocolNegotiationCache.class);
    private static final StampedLock lock = new StampedLock();
    private static final Map<String, CacheEntry> cache = new LruMap<String, CacheEntry>(65536){
        private static final long serialVersionUID = -2506868886873712772L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry> eldest) {
            boolean remove = super.removeEldestEntry(eldest);
            if (remove) {
                logger.debug("Evicted: '{}' does not support {}", (Object)eldest.getKey(), (Object)eldest.getValue());
            }
            return remove;
        }
    };

    public static boolean isUnsupported(Endpoint endpointWithPort, SessionProtocol protocol) {
        Objects.requireNonNull(endpointWithPort, "endpointWithPort");
        Preconditions.checkArgument(endpointWithPort.hasPort(), "endpointWithPort must have a port.");
        String key = SessionProtocolNegotiationCache.key(endpointWithPort.host(), endpointWithPort.port());
        return SessionProtocolNegotiationCache.isUnsupported(key, protocol);
    }

    public static boolean isUnsupported(SocketAddress remoteAddress, SessionProtocol protocol) {
        String key = SessionProtocolNegotiationCache.key(remoteAddress);
        return SessionProtocolNegotiationCache.isUnsupported(key, protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUnsupported(String key, SessionProtocol protocol) {
        CacheEntry e;
        Objects.requireNonNull(protocol, "protocol");
        long stamp = lock.readLock();
        try {
            e = cache.get(key);
        }
        finally {
            lock.unlockRead(stamp);
        }
        if (e == null) {
            return false;
        }
        return e.isUnsupported(protocol);
    }

    public static void setUnsupported(SocketAddress remoteAddress, SessionProtocol protocol) {
        Objects.requireNonNull(protocol, "protocol");
        String key = SessionProtocolNegotiationCache.key(remoteAddress);
        CacheEntry e = SessionProtocolNegotiationCache.getOrCreate(key);
        if (e.addUnsupported(protocol)) {
            logger.debug("Updated: '{}' does not support {}", (Object)key, (Object)e);
        }
    }

    public static void clear() {
        int size;
        long stamp = lock.readLock();
        try {
            size = cache.size();
            if (size == 0) {
                return;
            }
            stamp = SessionProtocolNegotiationCache.convertToWriteLock(stamp);
            size = cache.size();
            cache.clear();
        }
        finally {
            lock.unlock(stamp);
        }
        if (size != 0 && logger.isDebugEnabled()) {
            if (size != 1) {
                logger.debug("Cleared: {} entries", (Object)size);
            } else {
                logger.debug("Cleared: 1 entry");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheEntry getOrCreate(String key) {
        long stamp = lock.readLock();
        try {
            CacheEntry entry = cache.get(key);
            if (entry != null) {
                CacheEntry cacheEntry = entry;
                return cacheEntry;
            }
            stamp = SessionProtocolNegotiationCache.convertToWriteLock(stamp);
            CacheEntry cacheEntry = cache.computeIfAbsent(key, CacheEntry::new);
            return cacheEntry;
        }
        finally {
            lock.unlock(stamp);
        }
    }

    private static String key(SocketAddress remoteAddress) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("remoteAddress: " + remoteAddress + " (expected: an " + InetSocketAddress.class.getSimpleName() + ')');
        }
        InetSocketAddress raddr = (InetSocketAddress)remoteAddress;
        return SessionProtocolNegotiationCache.key(raddr.getHostString(), raddr.getPort());
    }

    private static String key(String host, int port) {
        return new StringBuilder(host.length() + 6).append(host).append(':').append(port).toString();
    }

    private static long convertToWriteLock(long stamp) {
        long writeStamp = lock.tryConvertToWriteLock(stamp);
        if (writeStamp == 0L) {
            lock.unlockRead(stamp);
            stamp = lock.writeLock();
        } else {
            stamp = writeStamp;
        }
        return stamp;
    }

    private SessionProtocolNegotiationCache() {
    }

    private static final class CacheEntry {
        private volatile Set<SessionProtocol> unsupported = ImmutableSet.of();

        CacheEntry(String key) {
        }

        boolean addUnsupported(SessionProtocol protocol) {
            Set<SessionProtocol> unsupported = this.unsupported;
            if (unsupported.contains((Object)protocol)) {
                return false;
            }
            this.unsupported = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(unsupported)).add((Object)protocol)).build();
            return true;
        }

        boolean isUnsupported(SessionProtocol protocol) {
            Objects.requireNonNull(protocol, "protocol");
            return this.unsupported.contains((Object)protocol);
        }

        public String toString() {
            return this.unsupported.toString();
        }
    }
}

