/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.DnsCache;
import com.linecorp.armeria.client.DnsCacheListener;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.client.dns.DefaultDnsResolver;
import com.linecorp.armeria.internal.client.dns.DnsQuestionWithoutTrailingDot;
import com.linecorp.armeria.internal.client.dns.DnsUtil;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.AbstractAddressResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RefreshingAddressResolver
extends AbstractAddressResolver<InetSocketAddress>
implements DnsCacheListener {
    private static final Logger logger = LoggerFactory.getLogger(RefreshingAddressResolver.class);
    private final Cache<String, CacheEntry> addressResolverCache;
    private final DefaultDnsResolver resolver;
    private final List<DnsRecordType> dnsRecordTypes;
    private final int negativeTtl;
    private final Backoff retryBackoff;
    private volatile boolean resolverClosed;

    RefreshingAddressResolver(EventLoop eventLoop, DefaultDnsResolver resolver, List<DnsRecordType> dnsRecordTypes, Cache<String, CacheEntry> addressResolverCache, DnsCache dnsResolverCache, int negativeTtl, Backoff retryBackoff) {
        super((EventExecutor)eventLoop);
        this.addressResolverCache = addressResolverCache;
        this.resolver = resolver;
        this.dnsRecordTypes = dnsRecordTypes;
        this.negativeTtl = negativeTtl;
        this.retryBackoff = retryBackoff;
        dnsResolverCache.addListener(this);
    }

    protected boolean doIsResolved(InetSocketAddress address) {
        return !Objects.requireNonNull(address, "address").isUnresolved();
    }

    protected void doResolve(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) throws Exception {
        Objects.requireNonNull(unresolvedAddress, "unresolvedAddress");
        Objects.requireNonNull(promise, "promise");
        if (this.resolverClosed) {
            promise.tryFailure((Throwable)new IllegalStateException("resolver is closed already."));
            return;
        }
        String hostname = unresolvedAddress.getHostString();
        int port = unresolvedAddress.getPort();
        CacheEntry entry = this.addressResolverCache.getIfPresent(hostname);
        if (entry != null) {
            this.complete(promise, entry, port);
            return;
        }
        CompletableFuture<CacheEntry> entryFuture = this.sendQuery(hostname);
        entryFuture.handle((entry0, unused) -> {
            if (entry0.cacheable()) {
                this.addressResolverCache.put(hostname, (CacheEntry)entry0);
            }
            this.complete(promise, (CacheEntry)entry0, port);
            return null;
        });
    }

    protected void doResolveAll(InetSocketAddress unresolvedAddress, Promise<List<InetSocketAddress>> promise) throws Exception {
        throw new UnsupportedOperationException();
    }

    private void complete(Promise<InetSocketAddress> promise, CacheEntry entry, int port) {
        Throwable cause = entry.cause();
        if (cause != null) {
            promise.tryFailure(cause);
        } else {
            promise.trySuccess((Object)new InetSocketAddress(entry.address(), port));
        }
    }

    private CompletableFuture<CacheEntry> sendQuery(String hostname) {
        List questions = this.dnsRecordTypes.stream().map(type -> DnsQuestionWithoutTrailingDot.of(hostname, type)).collect(ImmutableList.toImmutableList());
        return this.sendQueries(questions, hostname);
    }

    private CompletableFuture<CacheEntry> sendQueries(List<DnsQuestion> questions, String hostname) {
        return this.resolver.resolve(questions, hostname).handle((records, cause) -> {
            if (cause != null) {
                cause = Exceptions.peel(cause);
                return new CacheEntry(hostname, null, questions, (Throwable)cause);
            }
            InetAddress inetAddress = null;
            for (DnsRecord r : records) {
                byte[] addrBytes = DnsUtil.extractAddressBytes(r, logger, hostname);
                if (addrBytes == null) continue;
                try {
                    inetAddress = InetAddress.getByAddress(hostname, addrBytes);
                    break;
                }
                catch (UnknownHostException e) {
                    return new CacheEntry(hostname, null, questions, new IllegalArgumentException("Invalid address: " + hostname, e));
                }
            }
            if (inetAddress == null) {
                return new CacheEntry(hostname, null, questions, new UnknownHostException("failed to receive DNS records for " + hostname));
            }
            return new CacheEntry(hostname, inetAddress, questions, null);
        });
    }

    @Override
    public void onRemoval(DnsQuestion question, @Nullable List<DnsRecord> records, @Nullable UnknownHostException cause) {
        if (this.resolverClosed) {
            return;
        }
        DnsRecordType type = question.type();
        if (!type.equals((Object)DnsRecordType.A) && !type.equals((Object)DnsRecordType.AAAA)) {
            return;
        }
        assert (question instanceof DnsQuestionWithoutTrailingDot);
        DnsQuestionWithoutTrailingDot cast = (DnsQuestionWithoutTrailingDot)question;
        CacheEntry entry = this.addressResolverCache.getIfPresent(cast.originalName());
        if (entry != null && entry.refreshable()) {
            this.executor().execute(entry::refresh);
        }
    }

    public void close() {
        this.resolverClosed = true;
        this.resolver.close();
    }

    final class CacheEntry {
        @Nullable
        private final InetAddress address;
        private final List<DnsQuestion> questions;
        @Nullable
        private final Throwable cause;
        private final boolean cacheable;
        @Nullable
        private final ScheduledFuture<?> negativeCacheFuture;
        private boolean refreshing;
        @Nullable
        private ScheduledFuture<?> retryFuture;
        private int numAttemptsSoFar = 1;

        CacheEntry(@Nullable String hostname, InetAddress address, @Nullable List<DnsQuestion> questions, Throwable cause) {
            this.address = address;
            this.questions = questions;
            this.cause = cause;
            boolean cacheable = false;
            io.netty.util.concurrent.ScheduledFuture negativeCacheFuture = null;
            if (address != null) {
                cacheable = true;
            } else if (RefreshingAddressResolver.this.negativeTtl > 0 && cause instanceof UnknownHostException) {
                UnknownHostException unknownHostException = (UnknownHostException)cause;
                boolean bl = cacheable = unknownHostException.getCause() == null;
                if (cacheable) {
                    negativeCacheFuture = RefreshingAddressResolver.this.executor().schedule(() -> RefreshingAddressResolver.this.addressResolverCache.invalidate(hostname), (long)RefreshingAddressResolver.this.negativeTtl, TimeUnit.SECONDS);
                }
            }
            this.cacheable = cacheable;
            this.negativeCacheFuture = negativeCacheFuture;
        }

        @Nullable
        InetAddress address() {
            return this.address;
        }

        @Nullable
        Throwable cause() {
            return this.cause;
        }

        void clear() {
            RefreshingAddressResolver.this.executor().execute(() -> {
                if (this.retryFuture != null) {
                    this.retryFuture.cancel(false);
                }
                if (this.negativeCacheFuture != null) {
                    this.negativeCacheFuture.cancel(false);
                }
            });
        }

        void refresh() {
            if (RefreshingAddressResolver.this.resolverClosed) {
                return;
            }
            assert (this.refreshable());
            String hostname = this.address.getHostName();
            if (this.refreshing) {
                return;
            }
            this.refreshing = true;
            RefreshingAddressResolver.this.sendQueries(this.questions, hostname).thenAccept(entry -> {
                if (RefreshingAddressResolver.this.executor().inEventLoop()) {
                    this.maybeUpdate(hostname, (CacheEntry)entry);
                } else {
                    RefreshingAddressResolver.this.executor().execute(() -> this.maybeUpdate(hostname, (CacheEntry)entry));
                }
            });
        }

        @Nullable
        private Object maybeUpdate(String hostname, CacheEntry entry) {
            if (RefreshingAddressResolver.this.resolverClosed) {
                return null;
            }
            this.refreshing = false;
            Throwable cause = entry.cause();
            if (cause != null) {
                long nextDelayMillis = RefreshingAddressResolver.this.retryBackoff.nextDelayMillis(this.numAttemptsSoFar++);
                if (nextDelayMillis < 0L) {
                    RefreshingAddressResolver.this.addressResolverCache.invalidate(hostname);
                } else {
                    ScheduledFuture<?> retryFuture = this.retryFuture;
                    if (retryFuture != null) {
                        retryFuture.cancel(false);
                    }
                    this.retryFuture = RefreshingAddressResolver.this.executor().schedule(this::refresh, nextDelayMillis, TimeUnit.MILLISECONDS);
                }
                return null;
            }
            this.numAttemptsSoFar = 1;
            RefreshingAddressResolver.this.addressResolverCache.put(hostname, entry);
            return null;
        }

        boolean refreshable() {
            return this.address != null;
        }

        boolean cacheable() {
            return this.cacheable;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("address", this.address).add("questions", this.questions).add("cause", this.cause).add("cacheable", this.cacheable).add("numAttemptsSoFar", this.numAttemptsSoFar).toString();
        }
    }
}

