/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientHttpObjectEncoder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecodedHttpResponse;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.client.HttpSession;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.WriteTimeoutException;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpRequestSubscriber
implements ChannelFutureListener,
Subscriber<HttpObject> {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestSubscriber.class);
    private final Channel ch;
    private final ClientHttpObjectEncoder encoder;
    private final HttpResponseDecoder responseDecoder;
    private final HttpRequest request;
    private final DecodedHttpResponse originalRes;
    private final ClientRequestContext ctx;
    private final RequestLogBuilder logBuilder;
    private final long timeoutMillis;
    @Nullable
    private Subscription subscription;
    private int id = -1;
    @Nullable
    private HttpResponseDecoder.HttpResponseWrapper responseWrapper;
    @Nullable
    private ScheduledFuture<?> timeoutFuture;
    private State state = State.NEEDS_TO_WRITE_FIRST_HEADER;
    private boolean isSubscriptionCompleted;
    private boolean loggedRequestFirstBytesTransferred;

    HttpRequestSubscriber(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, HttpRequest request, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis) {
        this.ch = ch;
        this.encoder = encoder;
        this.responseDecoder = responseDecoder;
        this.request = request;
        this.originalRes = originalRes;
        this.ctx = ctx;
        this.logBuilder = ctx.logBuilder();
        this.timeoutMillis = timeoutMillis;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        this.cancelTimeout();
        try (SafeCloseable ignored = RequestContextUtil.pop();){
            if (future.isSuccess()) {
                if (!this.loggedRequestFirstBytesTransferred) {
                    this.logBuilder.requestFirstBytesTransferred();
                    this.loggedRequestFirstBytesTransferred = true;
                }
                if (this.state == State.DONE) {
                    this.logBuilder.endRequest();
                    assert (this.responseWrapper != null);
                    this.responseWrapper.initTimeout();
                }
                if (!this.isSubscriptionCompleted) {
                    assert (this.subscription != null);
                    this.subscription.request(1L);
                }
                return;
            }
            if (!this.loggedRequestFirstBytesTransferred) {
                this.fail(UnprocessedRequestException.of(future.cause()));
            } else {
                this.failAndReset(future.cause());
            }
        }
    }

    public void onSubscribe(Subscription subscription) {
        assert (this.subscription == null);
        this.subscription = subscription;
        if (this.state == State.DONE) {
            this.cancelSubscription();
            return;
        }
        HttpSession session = HttpSession.get(this.ch);
        this.id = session.incrementAndGetNumRequestsSent();
        if (this.id >= 0x20000000 || !session.canSendRequest()) {
            ClosedSessionException exception = this.id >= 0x20000000 ? new ClosedSessionException("Can't send requests more than 536870912 in one connection. ID: " + this.id) : new ClosedSessionException("Can't send requests. ID: " + this.id + ", session active: " + session.isActive() + ", response needs to disconnect: " + this.responseDecoder.needsToDisconnectWhenFinished());
            this.responseDecoder.disconnectWhenFinished();
            this.fail(UnprocessedRequestException.of(exception));
            return;
        }
        this.addResponseToDecoder();
        if (this.timeoutMillis > 0L) {
            this.timeoutFuture = this.ch.eventLoop().schedule(() -> this.failAndReset(WriteTimeoutException.get()), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        this.writeFirstHeader(session);
    }

    private void addResponseToDecoder() {
        long responseTimeoutMillis = this.ctx.responseTimeoutMillis();
        long maxContentLength = this.ctx.maxResponseLength();
        this.responseWrapper = this.responseDecoder.addResponse(this.id, this.originalRes, this.ctx, this.ch.eventLoop(), responseTimeoutMillis, maxContentLength);
    }

    private void writeFirstHeader(HttpSession session) {
        RequestHeaders firstHeaders = this.request.headers();
        SessionProtocol protocol = session.protocol();
        assert (protocol != null);
        boolean isEmpty = this.request.isEmpty();
        this.state = isEmpty ? State.DONE : State.NEEDS_DATA_OR_TRAILERS;
        RequestHeaders merged = HttpHeadersUtil.mergeRequestHeaders(firstHeaders, this.ctx.additionalRequestHeaders());
        this.logBuilder.requestHeaders(merged);
        ChannelPromise promise = this.ch.newPromise();
        promise.addListener((GenericFutureListener)this);
        this.encoder.writeHeaders(this.id, this.streamId(), merged, isEmpty, promise);
        this.ch.flush();
    }

    public void onNext(HttpObject o) {
        if (!(o instanceof HttpData) && !(o instanceof HttpHeaders)) {
            this.failAndReset(new IllegalArgumentException("published an HttpObject that's neither Http2Headers nor Http2Data: " + o));
            return;
        }
        boolean endOfStream = o.isEndOfStream();
        switch (this.state) {
            case NEEDS_DATA_OR_TRAILERS: {
                if (o instanceof HttpHeaders) {
                    HttpHeaders trailers = (HttpHeaders)o;
                    if (trailers.contains((CharSequence)HttpHeaderNames.STATUS)) {
                        this.failAndReset(new IllegalArgumentException("published a trailers with status: " + o));
                        return;
                    }
                    endOfStream = true;
                    this.logBuilder.requestTrailers(trailers);
                } else {
                    this.logBuilder.increaseRequestLength((HttpData)o);
                }
                this.write(o, endOfStream);
                break;
            }
            case DONE: {
                this.cancelSubscription();
                PooledObjects.close(o);
            }
        }
    }

    public void onError(Throwable cause) {
        this.isSubscriptionCompleted = true;
        if (this.id >= 0) {
            this.failAndReset(cause);
        } else {
            this.fail(UnprocessedRequestException.of(cause));
        }
    }

    public void onComplete() {
        this.isSubscriptionCompleted = true;
        this.cancelTimeout();
        if (this.state != State.DONE) {
            this.write(HttpData.empty(), true);
        }
    }

    private void write(HttpObject o, boolean endOfStream) {
        if (!this.ch.isActive()) {
            PooledObjects.close(o);
            this.fail(ClosedSessionException.get());
            return;
        }
        if (endOfStream) {
            this.state = State.DONE;
        }
        if (this.isStreamOrSessionClosed()) {
            return;
        }
        ChannelFuture future = o instanceof HttpHeaders ? this.encoder.writeTrailers(this.id, this.streamId(), (HttpHeaders)o) : this.encoder.writeData(this.id, this.streamId(), (HttpData)o, endOfStream);
        future.addListener((GenericFutureListener)this);
        this.ch.flush();
    }

    private boolean isStreamOrSessionClosed() {
        if (!this.encoder.isWritable(this.id, this.streamId())) {
            if (this.ctx.sessionProtocol().isMultiplex()) {
                this.failAndReset(ClosedStreamException.get());
            } else {
                this.failAndReset(ClosedSessionException.get());
            }
            return true;
        }
        return false;
    }

    private int streamId() {
        return (this.id << 1) + 1;
    }

    private void fail(Throwable cause) {
        this.state = State.DONE;
        this.cancelSubscription();
        this.logBuilder.endRequest(cause);
        if (this.responseWrapper != null) {
            if (this.responseWrapper.isOpen()) {
                this.responseWrapper.close(cause);
            } else {
                this.logBuilder.endResponse(cause);
            }
        } else {
            this.logBuilder.endResponse(cause);
            this.originalRes.close(cause);
        }
    }

    private void cancelSubscription() {
        this.isSubscriptionCompleted = true;
        assert (this.subscription != null);
        this.subscription.cancel();
    }

    private void failAndReset(Throwable cause) {
        if (cause instanceof ProxyConnectException) {
            return;
        }
        this.fail(cause);
        Http2Error error = Exceptions.isStreamCancelling(cause) ? Http2Error.CANCEL : Http2Error.INTERNAL_ERROR;
        if (error.code() != Http2Error.CANCEL.code()) {
            Exceptions.logIfUnexpected(logger, this.ch, HttpSession.get(this.ch).protocol(), "a request publisher raised an exception", cause);
        }
        if (this.ch.isActive()) {
            this.encoder.writeReset(this.id, this.streamId(), error);
            this.ch.flush();
        }
    }

    private boolean cancelTimeout() {
        ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
        if (timeoutFuture == null) {
            return true;
        }
        this.timeoutFuture = null;
        return timeoutFuture.cancel(false);
    }

    static enum State {
        NEEDS_TO_WRITE_FIRST_HEADER,
        NEEDS_DATA_OR_TRAILERS,
        DONE;

    }
}

