/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientHttp1ObjectEncoder;
import com.linecorp.armeria.client.Http1ResponseDecoder;
import com.linecorp.armeria.client.HttpSession;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.internal.common.Http1KeepAliveHandler;
import io.micrometer.core.instrument.Timer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;

final class Http1ClientKeepAliveHandler
extends Http1KeepAliveHandler {
    private static final RequestHeaders HTTP1_PING_REQUEST = RequestHeaders.of(HttpMethod.OPTIONS, "*");
    private final HttpSession httpSession;
    private final ClientHttp1ObjectEncoder encoder;
    private final Http1ResponseDecoder decoder;

    Http1ClientKeepAliveHandler(Channel channel, ClientHttp1ObjectEncoder encoder, Http1ResponseDecoder decoder, Timer keepAliveTimer, long idleTimeoutMillis, long pingIntervalMillis, long maxConnectionAgeMillis, int maxNumRequestsPerConnection) {
        super(channel, "client", keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection);
        this.httpSession = HttpSession.get(Objects.requireNonNull(channel, "channel"));
        this.encoder = Objects.requireNonNull(encoder, "encoder");
        this.decoder = Objects.requireNonNull(decoder, "decoder");
    }

    @Override
    protected ChannelFuture writePing(ChannelHandlerContext ctx) {
        int id = this.httpSession.incrementAndGetNumRequestsSent();
        this.decoder.setPingReqId(id);
        ChannelFuture future = this.encoder.writeHeaders(id, 0, HTTP1_PING_REQUEST, true, ctx.newPromise());
        ctx.flush();
        return future;
    }

    @Override
    protected boolean pingResetsPreviousPing() {
        return false;
    }

    @Override
    protected boolean hasRequestsInProgress(ChannelHandlerContext ctx) {
        return this.httpSession.hasUnfinishedResponses();
    }

    boolean isPing(int id) {
        return this.decoder.isPingReqId(id);
    }
}

