/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.linecorp.armeria.client.FutureResponseAs;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.RequestPreparationSetters;
import com.linecorp.armeria.client.ResponseAs;
import com.linecorp.armeria.client.WebClientRequestPreparation;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import io.netty.util.AttributeKey;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FutureTransformingRequestPreparation<T>
implements RequestPreparationSetters<CompletableFuture<T>> {
    private static final Logger logger = LoggerFactory.getLogger(FutureTransformingRequestPreparation.class);
    private final WebClientRequestPreparation delegate;
    private FutureResponseAs<T> responseAs;
    @Nullable
    private Function<? super Throwable, ?> errorHandler;

    FutureTransformingRequestPreparation(WebClientRequestPreparation delegate, FutureResponseAs<T> responseAs) {
        this.delegate = delegate;
        this.responseAs = responseAs;
    }

    @Override
    public CompletableFuture<T> execute() {
        CompletableFuture response;
        try {
            response = (CompletableFuture)this.responseAs.as(this.delegate.execute());
        }
        catch (Exception ex) {
            response = new CompletableFuture();
            response.completeExceptionally(ex);
        }
        if (this.errorHandler == null) {
            return response;
        }
        return response.exceptionally(cause -> {
            Object maybeRecovered = this.errorHandler.apply(cause = Exceptions.peel(cause));
            if (maybeRecovered instanceof Throwable) {
                return Exceptions.throwUnsafely((Throwable)maybeRecovered);
            }
            if (maybeRecovered != null) {
                return maybeRecovered;
            }
            return Exceptions.throwUnsafely(cause);
        });
    }

    public <U> FutureTransformingRequestPreparation<U> as(ResponseAs<? super T, ? extends U> responseAs) {
        Objects.requireNonNull(responseAs, "responseAs");
        this.responseAs = this.responseAs.map(responseAs::as);
        return this;
    }

    public FutureTransformingRequestPreparation<T> recover(Function<? super Throwable, ? extends @Nullable T> function) {
        Objects.requireNonNull(function, "function");
        this.errorHandler(function);
        return this;
    }

    public FutureTransformingRequestPreparation<T> mapError(Function<? super Throwable, ? extends @Nullable Throwable> function) {
        Objects.requireNonNull(function, "function");
        this.errorHandler(function);
        return this;
    }

    private void errorHandler(Function<? super Throwable, ?> errorHandler) {
        this.errorHandler = this.errorHandler == null ? errorHandler : this.errorHandler.andThen(obj -> {
            if (obj instanceof Throwable) {
                Object result = null;
                try {
                    result = errorHandler.apply((Throwable)obj);
                }
                catch (Throwable ex) {
                    logger.warn("Unexpected exception while handling {}", obj, (Object)ex);
                }
                if (result != null) {
                    return result;
                }
            }
            return obj;
        });
    }

    @Override
    public FutureTransformingRequestPreparation<T> requestOptions(RequestOptions requestOptions) {
        this.delegate.requestOptions(requestOptions);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> get(String path) {
        this.delegate.get(path);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> post(String path) {
        this.delegate.post(path);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> put(String path) {
        this.delegate.put(path);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> delete(String path) {
        this.delegate.delete(path);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> patch(String path) {
        this.delegate.patch(path);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> options(String path) {
        this.delegate.options(path);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> head(String path) {
        this.delegate.head(path);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> trace(String path) {
        this.delegate.trace(path);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> method(HttpMethod method) {
        this.delegate.method(method);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> path(String path) {
        this.delegate.path(path);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> content(String content) {
        this.delegate.content(content);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> content(MediaType contentType, CharSequence content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> content(MediaType contentType, String content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    @FormatMethod
    public FutureTransformingRequestPreparation<T> content(@FormatString String format, Object ... content) {
        this.delegate.content(format, content);
        return this;
    }

    @Override
    @FormatMethod
    public FutureTransformingRequestPreparation<T> content(MediaType contentType, @FormatString String format, Object ... content) {
        this.delegate.content(contentType, format, content);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> content(MediaType contentType, byte[] content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> content(MediaType contentType, HttpData content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> content(MediaType contentType, Publisher<? extends HttpData> content) {
        this.delegate.content(contentType, (Publisher)content);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> contentJson(Object content) {
        this.delegate.contentJson(content);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> header(CharSequence name, Object value) {
        this.delegate.header(name, value);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> headers(Iterable<? extends Map.Entry<? extends CharSequence, String>> headers) {
        this.delegate.headers((Iterable)headers);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> trailers(Iterable<? extends Map.Entry<? extends CharSequence, String>> trailers) {
        this.delegate.trailers((Iterable)trailers);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> pathParam(String name, Object value) {
        this.delegate.pathParam(name, value);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> pathParams(Map<String, ?> pathParams) {
        this.delegate.pathParams((Map)pathParams);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> disablePathParams() {
        this.delegate.disablePathParams();
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> queryParam(String name, Object value) {
        this.delegate.queryParam(name, value);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> queryParams(Iterable<? extends Map.Entry<? extends String, String>> queryParams) {
        this.delegate.queryParams((Iterable)queryParams);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> cookie(Cookie cookie) {
        this.delegate.cookie(cookie);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> cookies(Iterable<? extends Cookie> cookies) {
        this.delegate.cookies((Iterable)cookies);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> responseTimeout(Duration responseTimeout) {
        this.delegate.responseTimeout(responseTimeout);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> responseTimeoutMillis(long responseTimeoutMillis) {
        this.delegate.responseTimeoutMillis(responseTimeoutMillis);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> writeTimeout(Duration writeTimeout) {
        this.delegate.writeTimeout(writeTimeout);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> writeTimeoutMillis(long writeTimeoutMillis) {
        this.delegate.writeTimeoutMillis(writeTimeoutMillis);
        return this;
    }

    @Override
    public FutureTransformingRequestPreparation<T> maxResponseLength(long maxResponseLength) {
        this.delegate.maxResponseLength(maxResponseLength);
        return this;
    }

    @Override
    public <V> FutureTransformingRequestPreparation<T> attr(AttributeKey<V> key, @Nullable V value) {
        this.delegate.attr((AttributeKey)key, (Object)value);
        return this;
    }
}

