/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.net.HostAndPort;
import com.linecorp.armeria.internal.shaded.guava.net.InternetDomainName;
import io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.StandardProtocolFamily;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class Endpoint
implements EndpointGroup,
Comparable<Endpoint> {
    private static final Comparator<Endpoint> COMPARATOR = Comparator.comparing(Endpoint::host).thenComparing(e -> e.ipAddr, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(e -> e.port);
    private static final int DEFAULT_WEIGHT = 1000;
    private static final Predicate<String> SCHEME_VALIDATOR = scheme -> Pattern.compile("^([a-z][a-z0-9+\\-.]*)").matcher((CharSequence)scheme).matches();
    private static final Cache<String, Endpoint> cache = Caffeine.newBuilder().maximumSize(8192L).build();
    private final String host;
    @Nullable
    private final String ipAddr;
    private final int port;
    private final int weight;
    private final List<Endpoint> endpoints;
    private final HostType hostType;
    private final String authority;
    private final String strVal;
    @Nullable
    private CompletableFuture<Endpoint> selectFuture;
    @Nullable
    private CompletableFuture<List<Endpoint>> whenReadyFuture;
    private int hashCode;

    public static Endpoint parse(String authority) {
        Objects.requireNonNull(authority, "authority");
        Preconditions.checkArgument(!authority.isEmpty(), "authority is empty");
        return cache.get(authority, key -> {
            if (key.charAt(key.length() - 1) == ':') {
                throw new IllegalArgumentException("Missing port number: " + key);
            }
            HostAndPort hostAndPort = HostAndPort.fromString(Endpoint.removeUserInfo(key)).withDefaultPort(0);
            return Endpoint.create(hostAndPort.getHost(), hostAndPort.getPort(), true);
        });
    }

    public static Endpoint of(String host, int port) {
        Endpoint.validatePort("port", port);
        return Endpoint.create(host, port, true);
    }

    public static Endpoint of(String host) {
        return Endpoint.create(host, 0, true);
    }

    public static Endpoint unsafeCreate(String host, int port) {
        return Endpoint.create(host, port, false);
    }

    private static Endpoint create(String host, int port, boolean validateHost) {
        if (NetUtil.isValidIpV4Address((String)host)) {
            return new Endpoint(host, host, port, 1000, HostType.IPv4_ONLY);
        }
        if (NetUtil.isValidIpV6Address((String)host)) {
            String ipV6Addr = host.charAt(0) == '[' ? host.substring(1, host.length() - 1) : host;
            return new Endpoint(ipV6Addr, ipV6Addr, port, 1000, HostType.IPv6_ONLY);
        }
        if (validateHost) {
            host = InternetDomainName.from(host).toString();
        }
        return new Endpoint(host, null, port, 1000, HostType.HOSTNAME_ONLY);
    }

    private static String removeUserInfo(String authority) {
        int indexOfDelimiter = authority.lastIndexOf(64);
        if (indexOfDelimiter == -1) {
            return authority;
        }
        return authority.substring(indexOfDelimiter + 1);
    }

    private Endpoint(String host, @Nullable String ipAddr, int port, int weight, HostType hostType) {
        this.host = host;
        this.ipAddr = ipAddr;
        this.port = port;
        this.weight = weight;
        this.hostType = hostType;
        this.endpoints = ImmutableList.of(this);
        assert (ipAddr == null && hostType == HostType.HOSTNAME_ONLY || ipAddr != null && hostType != HostType.HOSTNAME_ONLY);
        this.authority = Endpoint.generateAuthority(host, port, hostType);
        this.strVal = Endpoint.generateToString(this.authority, ipAddr, weight, hostType);
    }

    private static String generateAuthority(String host, int port, HostType hostType) {
        if (port != 0) {
            if (hostType == HostType.IPv6_ONLY) {
                return '[' + host + "]:" + port;
            }
            return host + ':' + port;
        }
        if (hostType == HostType.IPv6_ONLY) {
            return '[' + host + ']';
        }
        return host;
    }

    private static String generateToString(String authority, @Nullable String ipAddr, int weight, HostType hostType) {
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append("Endpoint{").append(authority);
            if (hostType == HostType.HOSTNAME_AND_IPv4 || hostType == HostType.HOSTNAME_AND_IPv6) {
                buf.append(", ipAddr=").append(ipAddr);
            }
            String string = buf.append(", weight=").append(weight).append('}').toString();
            return string;
        }
    }

    @Override
    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    @Override
    public void addListener(Consumer<? super List<Endpoint>> listener, boolean notifyLatestEndpoints) {
        if (notifyLatestEndpoints) {
            listener.accept(this.endpoints);
        }
    }

    @Override
    public EndpointSelectionStrategy selectionStrategy() {
        return EndpointSelectionStrategy.weightedRoundRobin();
    }

    @Override
    public Endpoint selectNow(ClientRequestContext ctx) {
        return this;
    }

    @Override
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        if (this.selectFuture == null) {
            this.selectFuture = UnmodifiableFuture.completedFuture(this);
        }
        return this.selectFuture;
    }

    @Override
    public CompletableFuture<List<Endpoint>> whenReady() {
        if (this.whenReadyFuture == null) {
            this.whenReadyFuture = UnmodifiableFuture.completedFuture(this.endpoints);
        }
        return this.whenReadyFuture;
    }

    public String host() {
        return this.host;
    }

    @Nullable
    public String ipAddr() {
        return this.ipAddr;
    }

    public boolean hasIpAddr() {
        return this.ipAddr() != null;
    }

    public boolean isIpAddrOnly() {
        return this.hostType == HostType.IPv4_ONLY || this.hostType == HostType.IPv6_ONLY;
    }

    @Nullable
    public StandardProtocolFamily ipFamily() {
        switch (this.hostType) {
            case HOSTNAME_AND_IPv4: 
            case IPv4_ONLY: {
                return StandardProtocolFamily.INET;
            }
            case HOSTNAME_AND_IPv6: 
            case IPv6_ONLY: {
                return StandardProtocolFamily.INET6;
            }
        }
        return null;
    }

    public int port() {
        if (this.port == 0) {
            throw new IllegalStateException("port not specified");
        }
        return this.port;
    }

    public int port(int defaultValue) {
        return this.port != 0 ? this.port : defaultValue;
    }

    public boolean hasPort() {
        return this.port != 0;
    }

    public Endpoint withPort(int port) {
        Endpoint.validatePort("port", port);
        if (this.port == port) {
            return this;
        }
        return new Endpoint(this.host, this.ipAddr, port, this.weight, this.hostType);
    }

    public Endpoint withoutPort() {
        if (this.port == 0) {
            return this;
        }
        return new Endpoint(this.host, this.ipAddr, 0, this.weight, this.hostType);
    }

    public Endpoint withDefaultPort(int defaultPort) {
        Endpoint.validatePort("defaultPort", defaultPort);
        if (this.port != 0) {
            return this;
        }
        return new Endpoint(this.host, this.ipAddr, defaultPort, this.weight, this.hostType);
    }

    public Endpoint withoutDefaultPort(int defaultPort) {
        Endpoint.validatePort("defaultPort", defaultPort);
        if (this.port == defaultPort) {
            return new Endpoint(this.host, this.ipAddr, 0, this.weight, this.hostType);
        }
        return this;
    }

    public Endpoint withIpAddr(@Nullable String ipAddr) {
        if (ipAddr == null) {
            return this.withoutIpAddr();
        }
        if (ipAddr.equals(this.ipAddr)) {
            return this;
        }
        if (NetUtil.isValidIpV4Address((String)ipAddr)) {
            return this.withIpAddr(ipAddr, StandardProtocolFamily.INET);
        }
        if (NetUtil.isValidIpV6Address((String)ipAddr)) {
            boolean wrappedByBracket = ipAddr.charAt(0) == '[';
            int percentIdx = ipAddr.indexOf(37);
            if (percentIdx < 0) {
                if (wrappedByBracket) {
                    ipAddr = ipAddr.substring(1, ipAddr.length() - 1);
                }
            } else {
                ipAddr = ipAddr.substring(wrappedByBracket ? 1 : 0, percentIdx);
            }
            return this.withIpAddr(ipAddr, StandardProtocolFamily.INET6);
        }
        throw new IllegalArgumentException("ipAddr: " + ipAddr + " (expected: an IP address)");
    }

    private Endpoint withIpAddr(String ipAddr, StandardProtocolFamily ipFamily) {
        if (ipAddr.equals(this.ipAddr)) {
            return this;
        }
        if (this.isIpAddrOnly()) {
            return new Endpoint(ipAddr, ipAddr, this.port, this.weight, ipFamily == StandardProtocolFamily.INET ? HostType.IPv4_ONLY : HostType.IPv6_ONLY);
        }
        return new Endpoint(this.host(), ipAddr, this.port, this.weight, ipFamily == StandardProtocolFamily.INET ? HostType.HOSTNAME_AND_IPv4 : HostType.HOSTNAME_AND_IPv6);
    }

    public Endpoint withInetAddress(InetAddress address) {
        Objects.requireNonNull(address, "address");
        String ipAddr = address.getHostAddress();
        if (address instanceof Inet4Address) {
            return this.withIpAddr(ipAddr, StandardProtocolFamily.INET);
        }
        if (address instanceof Inet6Address) {
            return this.withIpAddr(ipAddr, StandardProtocolFamily.INET6);
        }
        return this.withIpAddr(ipAddr);
    }

    private Endpoint withoutIpAddr() {
        if (this.ipAddr == null) {
            return this;
        }
        if (this.isIpAddrOnly()) {
            throw new IllegalStateException("can't clear the IP address if host name is an IP address: " + this);
        }
        return new Endpoint(this.host(), null, this.port, this.weight, HostType.HOSTNAME_ONLY);
    }

    public Endpoint withWeight(int weight) {
        Endpoint.validateWeight(weight);
        if (this.weight == weight) {
            return this;
        }
        return new Endpoint(this.host(), this.ipAddr(), this.port, weight, this.hostType);
    }

    public int weight() {
        return this.weight;
    }

    public String authority() {
        return this.authority;
    }

    public URI toUri(String scheme) {
        Objects.requireNonNull(scheme, "scheme");
        return this.toUri(scheme, null);
    }

    public URI toUri(String scheme, @Nullable String path) {
        Objects.requireNonNull(scheme, "scheme");
        if (!SCHEME_VALIDATOR.test(scheme)) {
            throw new IllegalArgumentException("scheme: " + scheme + " (expected: a valid scheme)");
        }
        try {
            return new URI(scheme, this.authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public URI toUri(SessionProtocol sessionProtocol) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        return this.toUri(sessionProtocol, null);
    }

    public URI toUri(SessionProtocol sessionProtocol, @Nullable String path) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        return this.toUri(Scheme.of(SerializationFormat.NONE, sessionProtocol), path);
    }

    public URI toUri(Scheme scheme) {
        Objects.requireNonNull(scheme, "scheme");
        return this.toUri(scheme, null);
    }

    public URI toUri(Scheme scheme, @Nullable String path) {
        Objects.requireNonNull(scheme, "scheme");
        try {
            return new URI(scheme.uriText(), this.authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static void validatePort(String name, int port) {
        Preconditions.checkArgument(port > 0 && port <= 65535, "%s: %s (expected: 1-65535)", (Object)name, port);
    }

    private static void validateWeight(int weight) {
        Preconditions.checkArgument(weight >= 0, "weight: %s (expected: >= 0)", weight);
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public void close() {
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint that = (Endpoint)obj;
        return this.host().equals(that.host()) && Objects.equals(this.ipAddr, that.ipAddr) && this.port == that.port;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (this.host.hashCode() * 31 + Objects.hashCode(this.ipAddr)) * 31 + this.port;
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(Endpoint that) {
        return COMPARATOR.compare(this, that);
    }

    public String toString() {
        return this.strVal;
    }

    private static enum HostType {
        HOSTNAME_ONLY,
        HOSTNAME_AND_IPv4,
        HOSTNAME_AND_IPv6,
        IPv4_ONLY,
        IPv6_ONLY;

    }
}

