/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.BlockingWebClient;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.DefaultBlockingWebClient;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.UserClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.PathAndQuery;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import io.micrometer.core.instrument.MeterRegistry;
import java.net.URI;
import java.util.Objects;

final class DefaultWebClient
extends UserClient<HttpRequest, HttpResponse>
implements WebClient {
    static final WebClient DEFAULT = new WebClientBuilder().build();
    @Nullable
    private BlockingWebClient blockingWebClient;

    DefaultWebClient(ClientBuilderParams params, HttpClient delegate, MeterRegistry meterRegistry) {
        super(params, delegate, meterRegistry, HttpResponse::from, (ctx, cause) -> HttpResponse.ofFailure(cause));
    }

    @Override
    public HttpResponse execute(HttpRequest req, RequestOptions requestOptions) {
        Objects.requireNonNull(req, "req");
        Objects.requireNonNull(requestOptions, "requestOptions");
        if (Clients.isUndefinedUri(this.uri())) {
            SessionProtocol protocol;
            URI uri;
            if (ArmeriaHttpUtil.isAbsoluteUri(req.path())) {
                try {
                    uri = URI.create(req.path());
                }
                catch (Exception ex) {
                    return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Failed to create a URI: " + req.path(), ex));
                }
            } else if (req.scheme() != null && req.authority() != null) {
                uri = req.uri();
            } else {
                return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Scheme and authority must be specified in \":path\" or in \":scheme\" and \":authority\". :path=" + req.path() + ", :scheme=" + req.scheme() + ", :authority=" + req.authority()));
            }
            try {
                protocol = Scheme.parse(uri.getScheme()).sessionProtocol();
            }
            catch (Exception e) {
                return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Failed to parse a scheme: " + uri.getScheme(), e));
            }
            Endpoint endpoint = Endpoint.parse(uri.getAuthority());
            String query = uri.getRawQuery();
            String path = DefaultWebClient.pathWithQuery(uri, query);
            HttpRequest newReq = req.withHeaders(req.headers().toBuilder().path(path));
            return this.execute(endpoint, newReq, protocol, requestOptions);
        }
        if (ArmeriaHttpUtil.isAbsoluteUri(req.path())) {
            return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Cannot send a request with a \":path\" header that contains a URI with the authority, because the client was created with a base URI. path: " + req.path()));
        }
        String originalPath = req.path();
        String newPath = ArmeriaHttpUtil.concatPaths(this.uri().getRawPath(), originalPath);
        HttpRequest newReq = newPath != originalPath ? req.withHeaders(req.headers().toBuilder().path(newPath)) : req;
        return this.execute(this.endpointGroup(), newReq, this.scheme().sessionProtocol(), requestOptions);
    }

    private HttpResponse execute(EndpointGroup endpointGroup, HttpRequest req, SessionProtocol protocol, RequestOptions requestOptions) {
        PathAndQuery pathAndQuery = PathAndQuery.parse(req.path());
        if (pathAndQuery == null) {
            IllegalArgumentException cause = new IllegalArgumentException("invalid path: " + req.path());
            return DefaultWebClient.abortRequestAndReturnFailureResponse(req, cause);
        }
        String newPath = pathAndQuery.toString();
        if (!newPath.equals(req.path())) {
            req = req.withHeaders(req.headers().toBuilder().path(newPath));
        }
        return (HttpResponse)this.execute(protocol, endpointGroup, req.method(), pathAndQuery.path(), pathAndQuery.query(), null, req, requestOptions);
    }

    private static HttpResponse abortRequestAndReturnFailureResponse(HttpRequest req, IllegalArgumentException cause) {
        req.abort(cause);
        return HttpResponse.ofFailure(cause);
    }

    @Override
    public BlockingWebClient blocking() {
        if (this.blockingWebClient != null) {
            return this.blockingWebClient;
        }
        this.blockingWebClient = new DefaultBlockingWebClient(this);
        return this.blockingWebClient;
    }

    @Override
    public HttpClient unwrap() {
        return (HttpClient)super.unwrap();
    }

    static String pathWithQuery(URI uri, @Nullable String query) {
        String path = uri.getRawPath();
        if (Strings.isNullOrEmpty(path)) {
            path = query == null ? "/" : "/?" + query;
        } else if (query != null) {
            path = path + '?' + query;
        }
        return path;
    }
}

