/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ClientThreadLocalState;
import com.linecorp.armeria.client.DefaultWebClient;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.NonWrappingRequestContext;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.ReleasableHolder;
import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.common.PathAndQuery;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.util.AttributeKey;
import java.net.URI;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

public final class DefaultClientRequestContext
extends NonWrappingRequestContext
implements ClientRequestContext {
    private static final AtomicReferenceFieldUpdater<DefaultClientRequestContext, HttpHeaders> additionalRequestHeadersUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultClientRequestContext.class, HttpHeaders.class, "additionalRequestHeaders");
    private static final AtomicReferenceFieldUpdater<DefaultClientRequestContext, CompletableFuture> whenInitializedUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultClientRequestContext.class, CompletableFuture.class, "whenInitialized");
    private static final short STR_CHANNEL_AVAILABILITY = 1;
    private static final short STR_PARENT_LOG_AVAILABILITY = 2;
    private boolean initialized;
    @Nullable
    private EventLoop eventLoop;
    @Nullable
    private EndpointGroup endpointGroup;
    @Nullable
    private Endpoint endpoint;
    @Nullable
    private ContextAwareEventLoop contextAwareEventLoop;
    @Nullable
    private final String fragment;
    @Nullable
    private final ServiceRequestContext root;
    private final boolean hasBaseUri;
    private final ClientOptions options;
    private final RequestLogBuilder log;
    private final CancellationScheduler responseCancellationScheduler;
    private long writeTimeoutMillis;
    private long maxResponseLength;
    private volatile HttpHeaders additionalRequestHeaders;
    @Nullable
    private String strVal;
    private short strValAvailabilities;
    @Nullable
    private volatile Consumer<ClientRequestContext> customizer;
    @Nullable
    private volatile CompletableFuture<Boolean> whenInitialized;

    DefaultClientRequestContext(EventLoop eventLoop, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, HttpMethod method, String path, @Nullable String query, @Nullable String fragment, ClientOptions options, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, RequestOptions requestOptions, CancellationScheduler responseCancellationScheduler, long requestStartTimeNanos, long requestStartTimeMicros) {
        this(eventLoop, meterRegistry, sessionProtocol, id, method, path, query, fragment, options, req, rpcReq, requestOptions, DefaultClientRequestContext.serviceRequestContext(), responseCancellationScheduler, requestStartTimeNanos, requestStartTimeMicros, false);
    }

    public DefaultClientRequestContext(MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, HttpMethod method, String path, @Nullable String query, @Nullable String fragment, ClientOptions options, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, RequestOptions requestOptions, long requestStartTimeNanos, long requestStartTimeMicros, boolean hasBaseUri) {
        this(null, meterRegistry, sessionProtocol, id, method, path, query, fragment, options, req, rpcReq, requestOptions, DefaultClientRequestContext.serviceRequestContext(), null, requestStartTimeNanos, requestStartTimeMicros, hasBaseUri);
    }

    private DefaultClientRequestContext(@Nullable EventLoop eventLoop, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, HttpMethod method, String path, @Nullable String query, @Nullable String fragment, ClientOptions options, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, RequestOptions requestOptions, @Nullable ServiceRequestContext root, @Nullable CancellationScheduler responseCancellationScheduler, long requestStartTimeNanos, long requestStartTimeMicros, boolean hasBaseUri) {
        super(meterRegistry, sessionProtocol, id, method, path, query, req, rpcReq, root);
        this.eventLoop = eventLoop;
        this.hasBaseUri = hasBaseUri;
        this.options = Objects.requireNonNull(options, "options");
        this.fragment = fragment;
        this.root = root;
        this.log = RequestLog.builder(this);
        this.log.startRequest(requestStartTimeNanos, requestStartTimeMicros);
        if (responseCancellationScheduler == null) {
            long responseTimeoutMillis = requestOptions.responseTimeoutMillis();
            if (responseTimeoutMillis < 0L) {
                responseTimeoutMillis = this.options().responseTimeoutMillis();
            }
            this.responseCancellationScheduler = new CancellationScheduler(TimeUnit.MILLISECONDS.toNanos(responseTimeoutMillis));
        } else {
            this.responseCancellationScheduler = responseCancellationScheduler;
        }
        long writeTimeoutMillis = requestOptions.writeTimeoutMillis();
        if (writeTimeoutMillis < 0L) {
            writeTimeoutMillis = options.writeTimeoutMillis();
        }
        this.writeTimeoutMillis = writeTimeoutMillis;
        long maxResponseLength = requestOptions.maxResponseLength();
        if (maxResponseLength < 0L) {
            maxResponseLength = options.maxResponseLength();
        }
        this.maxResponseLength = maxResponseLength;
        for (Map.Entry<AttributeKey<?>, Object> attr : requestOptions.attrs().entrySet()) {
            this.setAttr(attr.getKey(), attr.getValue());
        }
        this.additionalRequestHeaders = (HttpHeaders)options.get(ClientOptions.HEADERS);
        Consumer<ClientRequestContext> customizer = options.contextCustomizer();
        Consumer<ClientRequestContext> threadLocalCustomizer = this.copyThreadLocalCustomizer();
        this.customizer = customizer == ClientOptions.CONTEXT_CUSTOMIZER.defaultValue() ? threadLocalCustomizer : (threadLocalCustomizer == null ? customizer : customizer.andThen(threadLocalCustomizer));
    }

    @Nullable
    private static ServiceRequestContext serviceRequestContext() {
        Object current = RequestContext.currentOrNull();
        return current != null ? current.root() : null;
    }

    public CompletableFuture<Boolean> init(EndpointGroup endpointGroup) {
        assert (this.endpoint == null) : this.endpoint;
        assert (!this.initialized);
        this.initialized = true;
        try {
            this.runContextCustomizer();
            endpointGroup = this.mapEndpoint(endpointGroup, this.hasBaseUri);
            if (endpointGroup instanceof Endpoint) {
                return this.initEndpoint((Endpoint)endpointGroup);
            }
            return this.initEndpointGroup(endpointGroup);
        }
        catch (Throwable t) {
            this.acquireEventLoop(endpointGroup);
            this.failEarly(t);
            return DefaultClientRequestContext.initFuture(false, null);
        }
    }

    private EndpointGroup mapEndpoint(EndpointGroup endpointGroup, boolean hasBaseUri) {
        if (endpointGroup instanceof Endpoint) {
            String authority;
            Endpoint endpoint = (Endpoint)endpointGroup;
            if (!hasBaseUri && (authority = this.additionalRequestHeaders.get((CharSequence)HttpHeaderNames.AUTHORITY)) != null) {
                endpoint = Endpoint.parse(authority);
            }
            return Objects.requireNonNull(this.options().endpointRemapper().apply(endpoint), "endpointRemapper returned null.");
        }
        return endpointGroup;
    }

    private CompletableFuture<Boolean> initEndpoint(Endpoint endpoint) {
        this.endpointGroup = null;
        this.updateEndpoint(endpoint);
        this.acquireEventLoop(endpoint);
        return DefaultClientRequestContext.initFuture(true, null);
    }

    private CompletableFuture<Boolean> initEndpointGroup(EndpointGroup endpointGroup) {
        this.endpointGroup = endpointGroup;
        Endpoint endpoint = endpointGroup.selectNow(this);
        if (endpoint != null) {
            this.updateEndpoint(endpoint);
            this.acquireEventLoop(endpointGroup);
            return DefaultClientRequestContext.initFuture(true, null);
        }
        EventLoop temporaryEventLoop = this.options().factory().eventLoopSupplier().get();
        return ((CompletableFuture)endpointGroup.select(this, (ScheduledExecutorService)temporaryEventLoop, this.connectTimeoutMillis()).handle((e, cause) -> {
            boolean success;
            this.updateEndpoint((Endpoint)e);
            this.acquireEventLoop(endpointGroup);
            if (cause != null) {
                this.failEarly((Throwable)cause);
                success = false;
            } else {
                success = true;
            }
            ContextAwareEventLoop acquiredEventLoop = this.eventLoop();
            if (acquiredEventLoop == temporaryEventLoop) {
                return DefaultClientRequestContext.initFuture(success, null);
            }
            return DefaultClientRequestContext.initFuture(success, acquiredEventLoop);
        })).thenCompose(Function.identity());
    }

    private static CompletableFuture<Boolean> initFuture(boolean success, @Nullable EventLoop acquiredEventLoop) {
        if (acquiredEventLoop == null) {
            return UnmodifiableFuture.completedFuture(success);
        }
        return CompletableFuture.supplyAsync(() -> success, (Executor)acquiredEventLoop);
    }

    public CompletableFuture<Boolean> whenInitialized() {
        CompletableFuture<Boolean> whenInitialized = this.whenInitialized;
        if (whenInitialized != null) {
            return whenInitialized;
        }
        whenInitialized = new CompletableFuture();
        if (whenInitializedUpdater.compareAndSet(this, null, whenInitialized)) {
            return whenInitialized;
        }
        return this.whenInitialized;
    }

    public void finishInitialization(boolean success) {
        CompletableFuture<Boolean> whenInitialized = this.whenInitialized;
        if (whenInitialized != null) {
            whenInitialized.complete(success);
        } else if (!whenInitializedUpdater.compareAndSet(this, null, UnmodifiableFuture.completedFuture(success))) {
            this.whenInitialized.complete(success);
        }
    }

    private void updateEndpoint(@Nullable Endpoint endpoint) {
        this.endpoint = endpoint;
        this.autoFillSchemeAndAuthority();
    }

    private void acquireEventLoop(EndpointGroup endpointGroup) {
        if (this.eventLoop == null) {
            ReleasableHolder<EventLoop> releasableEventLoop = this.options().factory().acquireEventLoop(this.sessionProtocol(), endpointGroup, this.endpoint);
            this.eventLoop = releasableEventLoop.get();
            this.log.whenComplete().thenAccept(unused -> releasableEventLoop.release());
        }
    }

    private void runContextCustomizer() {
        Consumer<ClientRequestContext> customizer = this.customizer;
        if (customizer != null) {
            this.customizer = null;
            customizer.accept(this);
        }
    }

    private long connectTimeoutMillis() {
        Integer boxedConnectTimeoutMillis = (Integer)this.options.factory().options().channelOptions().get(ChannelOption.CONNECT_TIMEOUT_MILLIS);
        return boxedConnectTimeoutMillis != null ? boxedConnectTimeoutMillis.longValue() : Flags.defaultConnectTimeoutMillis();
    }

    private void failEarly(Throwable cause) {
        UnprocessedRequestException wrapped = UnprocessedRequestException.of(cause);
        HttpRequest req = this.request();
        if (req != null) {
            this.autoFillSchemeAndAuthority();
            req.abort(wrapped);
        }
        RequestLogBuilder logBuilder = this.logBuilder();
        logBuilder.endRequest(wrapped);
        logBuilder.endResponse(wrapped);
    }

    private void autoFillSchemeAndAuthority() {
        String authority;
        HttpRequest req = this.request();
        if (req == null) {
            return;
        }
        RequestHeaders headers = req.headers();
        String string = authority = this.endpoint != null ? this.endpoint.authority() : "UNKNOWN";
        if (headers.scheme() == null || !authority.equals(headers.authority())) {
            RequestHeadersBuilder headersBuilder = headers.toBuilder();
            if (headers.scheme() == null) {
                headersBuilder.scheme(this.sessionProtocol());
            }
            if (headersBuilder.get((CharSequence)HttpHeaderNames.HOST) != null) {
                headersBuilder.set((CharSequence)HttpHeaderNames.HOST, authority);
            } else {
                headersBuilder.authority(authority);
            }
            this.unsafeUpdateRequest(req.withHeaders(headersBuilder));
        }
    }

    private DefaultClientRequestContext(DefaultClientRequestContext ctx, RequestId id, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, @Nullable Endpoint endpoint, @Nullable EndpointGroup endpointGroup, SessionProtocol sessionProtocol, HttpMethod method, String path, @Nullable String query, @Nullable String fragment) {
        super(ctx.meterRegistry(), sessionProtocol, id, method, path, query, req, rpcReq, ctx.root());
        if (ctx.request() != null) {
            Objects.requireNonNull(req, "req");
        }
        this.eventLoop = ctx.eventLoop().withoutContext();
        this.hasBaseUri = ctx.hasBaseUri;
        this.options = ctx.options();
        this.endpointGroup = endpointGroup;
        this.updateEndpoint(endpoint);
        this.fragment = fragment;
        this.root = ctx.root();
        this.log = RequestLog.builder(this);
        this.log.startRequest();
        this.responseCancellationScheduler = new CancellationScheduler(TimeUnit.MILLISECONDS.toNanos(ctx.responseTimeoutMillis()));
        this.writeTimeoutMillis = ctx.writeTimeoutMillis();
        this.maxResponseLength = ctx.maxResponseLength();
        this.additionalRequestHeaders = ctx.additionalRequestHeaders();
        Iterator<Map.Entry<AttributeKey<?>, Object>> i = ctx.ownAttrs();
        while (i.hasNext()) {
            this.addAttr(i.next());
        }
    }

    @Nullable
    private Consumer<ClientRequestContext> copyThreadLocalCustomizer() {
        ClientThreadLocalState state = ClientThreadLocalState.get();
        if (state == null) {
            return null;
        }
        state.addCapturedContext(this);
        List<Consumer<? super ClientRequestContext>> customizers = state.copyCustomizers();
        if (customizers == null) {
            return null;
        }
        return ctx -> {
            for (Consumer c : customizers) {
                c.accept(this);
            }
        };
    }

    private <T> void addAttr(Map.Entry<AttributeKey<?>, Object> attribute) {
        this.setAttr(attribute.getKey(), attribute.getValue());
    }

    @Override
    @Nullable
    public ServiceRequestContext root() {
        return this.root;
    }

    @Override
    public ClientRequestContext newDerivedContext(RequestId id, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, @Nullable Endpoint endpoint) {
        if (req != null) {
            RequestHeaders newHeaders = req.headers();
            String newPath = newHeaders.path();
            if (!this.path().equals(newPath)) {
                if (!ArmeriaHttpUtil.isAbsoluteUri(newPath)) {
                    return this.newDerivedContext(id, req, rpcReq, newHeaders, this.sessionProtocol(), endpoint, newPath);
                }
                URI uri = URI.create(req.path());
                Scheme scheme = Scheme.parse(uri.getScheme());
                SessionProtocol protocol = scheme.sessionProtocol();
                Endpoint newEndpoint = Endpoint.parse(uri.getAuthority());
                String rawQuery = uri.getRawQuery();
                String pathWithQuery = DefaultWebClient.pathWithQuery(uri, rawQuery);
                HttpRequest newReq = req.withHeaders(req.headers().toBuilder().path(pathWithQuery));
                return this.newDerivedContext(id, newReq, rpcReq, newHeaders, protocol, newEndpoint, pathWithQuery);
            }
        }
        return new DefaultClientRequestContext(this, id, req, rpcReq, endpoint, this.endpointGroup(), this.sessionProtocol(), this.method(), this.path(), this.query(), this.fragment());
    }

    private ClientRequestContext newDerivedContext(RequestId id, HttpRequest req, @Nullable RpcRequest rpcReq, RequestHeaders newHeaders, SessionProtocol protocol, @Nullable Endpoint endpoint, String pathWithQuery) {
        PathAndQuery pathAndQuery = PathAndQuery.parse(pathWithQuery);
        if (pathAndQuery == null) {
            throw new IllegalArgumentException("invalid path: " + req.path());
        }
        return new DefaultClientRequestContext(this, id, req, rpcReq, endpoint, null, protocol, newHeaders.method(), pathAndQuery.path(), pathAndQuery.query(), null);
    }

    @Override
    protected void validateHeaders(RequestHeaders headers) {
        if (!this.initialized) {
            return;
        }
        super.validateHeaders(headers);
    }

    @Override
    @Nullable
    protected Channel channel() {
        if (this.log.isAvailable(RequestLogProperty.SESSION)) {
            return this.log.partial().channel();
        }
        return null;
    }

    @Override
    public ContextAwareEventLoop eventLoop() {
        Preconditions.checkState(this.eventLoop != null, "Should call init(endpoint) before invoking this method.");
        if (this.contextAwareEventLoop != null) {
            return this.contextAwareEventLoop;
        }
        this.contextAwareEventLoop = ContextAwareEventLoop.of((RequestContext)this, this.eventLoop);
        return this.contextAwareEventLoop;
    }

    @Override
    public ByteBufAllocator alloc() {
        Channel channel = this.channel();
        return channel != null ? channel.alloc() : PooledByteBufAllocator.DEFAULT;
    }

    @Override
    @Nullable
    public SSLSession sslSession() {
        if (this.log.isAvailable(RequestLogProperty.SESSION)) {
            return this.log.partial().sslSession();
        }
        return null;
    }

    @Override
    public ClientOptions options() {
        return this.options;
    }

    @Override
    public EndpointGroup endpointGroup() {
        return this.endpointGroup;
    }

    @Override
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    @Nullable
    public String fragment() {
        return this.fragment;
    }

    @Override
    public long writeTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    @Override
    public void setWriteTimeoutMillis(long writeTimeoutMillis) {
        Preconditions.checkArgument(writeTimeoutMillis >= 0L, "writeTimeoutMillis: %s (expected: >= 0)", writeTimeoutMillis);
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    @Override
    public void setWriteTimeout(Duration writeTimeout) {
        this.setWriteTimeoutMillis(Objects.requireNonNull(writeTimeout, "writeTimeout").toMillis());
    }

    @Override
    public long responseTimeoutMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.responseCancellationScheduler.timeoutNanos());
    }

    @Override
    public void clearResponseTimeout() {
        this.responseCancellationScheduler.clearTimeout();
    }

    @Override
    public void setResponseTimeoutMillis(TimeoutMode mode, long responseTimeoutMillis) {
        this.responseCancellationScheduler.setTimeoutNanos(Objects.requireNonNull(mode, "mode"), TimeUnit.MILLISECONDS.toNanos(responseTimeoutMillis));
    }

    @Override
    public void setResponseTimeout(TimeoutMode mode, Duration responseTimeout) {
        this.responseCancellationScheduler.setTimeoutNanos(Objects.requireNonNull(mode, "mode"), Objects.requireNonNull(responseTimeout, "responseTimeout").toNanos());
    }

    @Override
    public long maxResponseLength() {
        return this.maxResponseLength;
    }

    @Override
    public void setMaxResponseLength(long maxResponseLength) {
        Preconditions.checkArgument(maxResponseLength >= 0L, "maxResponseLength: %s (expected: >= 0)", maxResponseLength);
        this.maxResponseLength = maxResponseLength;
    }

    @Override
    public HttpHeaders additionalRequestHeaders() {
        return this.additionalRequestHeaders;
    }

    @Override
    public void setAdditionalRequestHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.mutateAdditionalRequestHeaders(builder -> builder.setObject(name, value));
    }

    @Override
    public void addAdditionalRequestHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.mutateAdditionalRequestHeaders(builder -> builder.addObject(name, value));
    }

    @Override
    public void mutateAdditionalRequestHeaders(Consumer<HttpHeadersBuilder> mutator) {
        HttpHeadersBuilder builder;
        HttpHeaders newValue;
        HttpHeaders oldValue;
        Objects.requireNonNull(mutator, "mutator");
        do {
            oldValue = this.additionalRequestHeaders;
            builder = oldValue.toBuilder();
            mutator.accept(builder);
        } while (!additionalRequestHeadersUpdater.compareAndSet(this, oldValue, newValue = builder.build()));
    }

    @Override
    public RequestLogAccess log() {
        return this.log;
    }

    @Override
    public RequestLogBuilder logBuilder() {
        return this.log;
    }

    CancellationScheduler responseCancellationScheduler() {
        return this.responseCancellationScheduler;
    }

    @Override
    public void cancel(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.responseCancellationScheduler.finishNow(cause);
    }

    @Override
    @Nullable
    public Throwable cancellationCause() {
        return this.responseCancellationScheduler.cause();
    }

    @Override
    public CompletableFuture<Throwable> whenResponseCancelling() {
        return this.responseCancellationScheduler.whenCancelling();
    }

    @Override
    public CompletableFuture<Throwable> whenResponseCancelled() {
        return this.responseCancellationScheduler.whenCancelled();
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> whenResponseTimingOut() {
        return this.responseCancellationScheduler.whenTimingOut();
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> whenResponseTimedOut() {
        return this.responseCancellationScheduler.whenTimedOut();
    }

    public String toString() {
        Channel ch = this.channel();
        RequestLogAccess parent = this.log().parent();
        short newAvailability = (short)((ch != null ? 1 : 0) | (parent != null ? 2 : 0));
        if (this.strVal != null && this.strValAvailabilities == newAvailability) {
            return this.strVal;
        }
        this.strValAvailabilities = newAvailability;
        this.strVal = this.toStringSlow(ch, parent);
        return this.strVal;
    }

    private String toStringSlow(@Nullable Channel ch, @Nullable RequestLogAccess parent) {
        String creqId = this.id().shortText();
        String preqId = parent != null ? parent.context().id().shortText() : null;
        String sreqId = this.root() != null ? this.root().id().shortText() : null;
        String chanId = ch != null ? ch.id().asShortText() : null;
        String proto = this.sessionProtocol().uriText();
        String authority = this.endpoint != null ? this.endpoint.authority() : "UNKNOWN";
        String path = this.path();
        String method = this.method().name();
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append("[creqId=").append(creqId);
            if (parent != null) {
                buf.append(", preqId=").append(preqId);
            }
            if (sreqId != null) {
                buf.append(", sreqId=").append(sreqId);
            }
            if (ch != null) {
                buf.append(", chanId=").append(chanId).append(", laddr=");
                TextFormatter.appendSocketAddress(buf, ch.localAddress());
                buf.append(", raddr=");
                TextFormatter.appendSocketAddress(buf, ch.remoteAddress());
            }
            buf.append("][").append(proto).append("://").append(authority).append(path).append('#').append(method).append(']');
            String string = buf.toString();
            return string;
        }
    }
}

