/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.DefaultHttpResponse;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;

final class DecodedHttpResponse
extends DefaultHttpResponse {
    private final EventLoop eventLoop;
    @Nullable
    private InboundTrafficController inboundTrafficController;
    private long writtenBytes;

    DecodedHttpResponse(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    void init(InboundTrafficController inboundTrafficController) {
        this.inboundTrafficController = inboundTrafficController;
    }

    long writtenBytes() {
        return this.writtenBytes;
    }

    @Override
    public EventExecutor defaultSubscriberExecutor() {
        return this.eventLoop;
    }

    @Override
    public boolean tryWrite(HttpObject obj) {
        boolean published = super.tryWrite(obj);
        if (published && obj instanceof HttpData) {
            int length = ((HttpData)obj).length();
            assert (this.inboundTrafficController != null);
            this.inboundTrafficController.inc(length);
            this.writtenBytes += (long)length;
        }
        return published;
    }

    @Override
    protected void onRemoval(HttpObject obj) {
        if (obj instanceof HttpData) {
            int length = ((HttpData)obj).length();
            assert (this.inboundTrafficController != null);
            this.inboundTrafficController.dec(length);
        }
    }
}

