/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DefaultClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.common.AbstractRequestContextBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.ClientConnectionTimings;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

public final class ClientRequestContextBuilder
extends AbstractRequestContextBuilder {
    private static final CancellationScheduler.CancellationTask noopCancellationTask = new CancellationScheduler.CancellationTask(){

        @Override
        public boolean canSchedule() {
            return true;
        }

        @Override
        public void run(Throwable cause) {
        }
    };
    private static final CancellationScheduler noopResponseCancellationScheduler = new CancellationScheduler(0L);
    @Nullable
    private final String fragment;
    @Nullable
    private Endpoint endpoint;
    private ClientOptions options = ClientOptions.of();
    private RequestOptions requestOptions = RequestOptions.of();
    @Nullable
    private ClientConnectionTimings connectionTimings;

    ClientRequestContextBuilder(HttpRequest request) {
        super(false, request);
        this.fragment = null;
    }

    ClientRequestContextBuilder(RpcRequest request, URI uri) {
        super(false, request, uri);
        this.fragment = uri.getRawFragment();
    }

    @Override
    public ClientRequestContextBuilder method(HttpMethod method) {
        super.method(method);
        return this;
    }

    public ClientRequestContextBuilder endpoint(Endpoint endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
        return this;
    }

    public ClientRequestContextBuilder options(ClientOptions options) {
        this.options = Objects.requireNonNull(options, "options");
        return this;
    }

    public ClientRequestContextBuilder connectionTimings(ClientConnectionTimings connectionTimings) {
        this.connectionTimings = Objects.requireNonNull(connectionTimings, "connectionTimings");
        return this;
    }

    public ClientRequestContextBuilder requestOptions(RequestOptions requestOptions) {
        this.requestOptions = Objects.requireNonNull(requestOptions, "requestOptions");
        return this;
    }

    public ClientRequestContext build() {
        CancellationScheduler responseCancellationScheduler;
        Endpoint endpoint = this.endpoint != null ? this.endpoint : Endpoint.parse(this.authority());
        if (this.timedOut()) {
            responseCancellationScheduler = noopResponseCancellationScheduler;
        } else {
            responseCancellationScheduler = new CancellationScheduler(0L);
            CountDownLatch latch = new CountDownLatch(1);
            this.eventLoop().execute(() -> {
                responseCancellationScheduler.init((EventExecutor)this.eventLoop(), noopCancellationTask, 0L, false);
                latch.countDown();
            });
            try {
                latch.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        DefaultClientRequestContext ctx = new DefaultClientRequestContext(this.eventLoop(), this.meterRegistry(), this.sessionProtocol(), this.id(), this.method(), this.path(), this.query(), this.fragment, this.options, this.request(), this.rpcRequest(), this.requestOptions, responseCancellationScheduler, this.isRequestStartTimeSet() ? this.requestStartTimeNanos() : System.nanoTime(), this.isRequestStartTimeSet() ? this.requestStartTimeMicros() : SystemInfo.currentTimeMicros());
        ctx.init(endpoint);
        ctx.logBuilder().session(this.fakeChannel(), this.sessionProtocol(), this.sslSession(), this.connectionTimings);
        if (this.request() != null) {
            ctx.logBuilder().requestHeaders(this.request().headers());
        }
        if (this.rpcRequest() != null) {
            ctx.logBuilder().requestContent(this.rpcRequest(), null);
        }
        return ctx;
    }

    @Override
    public ClientRequestContextBuilder meterRegistry(MeterRegistry meterRegistry) {
        return (ClientRequestContextBuilder)super.meterRegistry(meterRegistry);
    }

    @Override
    public ClientRequestContextBuilder eventLoop(EventLoop eventLoop) {
        return (ClientRequestContextBuilder)super.eventLoop(eventLoop);
    }

    @Override
    public ClientRequestContextBuilder alloc(ByteBufAllocator alloc) {
        return (ClientRequestContextBuilder)super.alloc(alloc);
    }

    @Override
    public ClientRequestContextBuilder sessionProtocol(SessionProtocol sessionProtocol) {
        return (ClientRequestContextBuilder)super.sessionProtocol(sessionProtocol);
    }

    @Override
    public ClientRequestContextBuilder id(RequestId id) {
        return (ClientRequestContextBuilder)super.id(id);
    }

    @Override
    public ClientRequestContextBuilder remoteAddress(SocketAddress remoteAddress) {
        return (ClientRequestContextBuilder)super.remoteAddress(remoteAddress);
    }

    @Override
    public ClientRequestContextBuilder localAddress(SocketAddress localAddress) {
        return (ClientRequestContextBuilder)super.localAddress(localAddress);
    }

    @Override
    public ClientRequestContextBuilder sslSession(SSLSession sslSession) {
        return (ClientRequestContextBuilder)super.sslSession(sslSession);
    }

    @Override
    public ClientRequestContextBuilder requestStartTime(long requestStartTimeNanos, long requestStartTimeMicros) {
        return (ClientRequestContextBuilder)super.requestStartTime(requestStartTimeNanos, requestStartTimeMicros);
    }

    @Override
    public ClientRequestContextBuilder timedOut(boolean timedOut) {
        return (ClientRequestContextBuilder)super.timedOut(timedOut);
    }

    static {
        noopResponseCancellationScheduler.init((EventExecutor)ImmediateEventExecutor.INSTANCE, noopCancellationTask, 0L, false);
        noopResponseCancellationScheduler.finishNow();
    }
}

