/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientHttpObjectEncoder;
import com.linecorp.armeria.client.Http1ClientKeepAliveHandler;
import com.linecorp.armeria.common.Http1HeaderNaming;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.client.HttpHeaderUtil;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.Http1ObjectEncoder;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;

final class ClientHttp1ObjectEncoder
extends Http1ObjectEncoder
implements ClientHttpObjectEncoder {
    private final Http1HeaderNaming http1HeaderNaming;
    private KeepAliveHandler keepAliveHandler = NoopKeepAliveHandler.INSTANCE;

    ClientHttp1ObjectEncoder(Channel ch, SessionProtocol protocol, Http1HeaderNaming http1HeaderNaming) {
        super(ch, protocol);
        this.http1HeaderNaming = http1HeaderNaming;
    }

    @Override
    public ChannelFuture doWriteHeaders(int id, int streamId, RequestHeaders headers, boolean endStream, ChannelPromise promise) {
        return this.writeNonInformationalHeaders(id, this.convertHeaders(headers, endStream), endStream, promise);
    }

    private HttpObject convertHeaders(RequestHeaders headers, boolean endStream) {
        String method = headers.method().name();
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)method), headers.path(), false);
        io.netty.handler.codec.http.HttpHeaders nettyHeaders = req.headers();
        ArmeriaHttpUtil.toNettyHttp1ClientHeaders(headers, nettyHeaders, this.http1HeaderNaming);
        if (!nettyHeaders.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            nettyHeaders.add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)HttpHeaderUtil.USER_AGENT.toString());
        }
        if (!nettyHeaders.contains((CharSequence)HttpHeaderNames.HOST)) {
            InetSocketAddress remoteAddress = (InetSocketAddress)this.channel().remoteAddress();
            nettyHeaders.add((CharSequence)HttpHeaderNames.HOST, (Object)ArmeriaHttpUtil.authorityHeader(remoteAddress.getHostName(), remoteAddress.getPort(), this.protocol().defaultPort()));
        }
        if (endStream) {
            nettyHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            switch (method) {
                case "POST": 
                case "PUT": 
                case "PATCH": {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
                    break;
                }
                default: {
                    nettyHeaders.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                    break;
                }
            }
        } else if (HttpUtil.getContentLength((HttpMessage)req, (long)-1L) >= 0L) {
            nettyHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        } else {
            nettyHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        return req;
    }

    @Override
    protected void convertTrailers(HttpHeaders inputHeaders, io.netty.handler.codec.http.HttpHeaders outputHeaders) {
        ArmeriaHttpUtil.toNettyHttp1ClientTrailers(inputHeaders, outputHeaders, this.http1HeaderNaming);
    }

    @Override
    public KeepAliveHandler keepAliveHandler() {
        return this.keepAliveHandler;
    }

    void setKeepAliveHandler(KeepAliveHandler keepAliveHandler) {
        assert (keepAliveHandler instanceof Http1ClientKeepAliveHandler);
        this.keepAliveHandler = keepAliveHandler;
    }

    @Override
    protected boolean isPing(int id) {
        return this.keepAliveHandler instanceof Http1ClientKeepAliveHandler && ((Http1ClientKeepAliveHandler)this.keepAliveHandler).isPing(id);
    }
}

