/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractClientOptionsBuilder;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.DecoratingRpcClientFunction;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractWebClientBuilder
extends AbstractClientOptionsBuilder {
    static final URI UNDEFINED_URI = URI.create("http://undefined");
    private static final Set<SessionProtocol> SUPPORTED_PROTOCOLS = Sets.immutableEnumSet(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(SessionProtocol.httpValues())).addAll(SessionProtocol.httpsValues())).build());
    @Nullable
    private final URI uri;
    @Nullable
    private final EndpointGroup endpointGroup;
    @Nullable
    private final Scheme scheme;
    @Nullable
    private final String path;

    protected AbstractWebClientBuilder() {
        this.uri = UNDEFINED_URI;
        this.scheme = null;
        this.endpointGroup = null;
        this.path = null;
    }

    protected AbstractWebClientBuilder(URI uri) {
        String givenScheme;
        Scheme scheme;
        this.uri = Clients.isUndefinedUri(uri) ? uri : ((scheme = AbstractWebClientBuilder.validateScheme(givenScheme = Objects.requireNonNull(uri, "uri").getScheme())).uriText().equals(givenScheme) ? uri : URI.create(scheme.uriText() + uri.toString().substring(givenScheme.length())));
        this.scheme = null;
        this.endpointGroup = null;
        this.path = null;
    }

    protected AbstractWebClientBuilder(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, @Nullable String path) {
        AbstractWebClientBuilder.validateScheme(Objects.requireNonNull(sessionProtocol, "sessionProtocol").uriText());
        if (path != null) {
            Preconditions.checkArgument(path.startsWith("/"), "path: %s (expected: an absolute path starting with '/')", (Object)path);
        }
        this.uri = null;
        this.scheme = Scheme.of(SerializationFormat.NONE, sessionProtocol);
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
        this.path = path;
    }

    private static Scheme validateScheme(String scheme) {
        Scheme parsedScheme = Scheme.tryParse(scheme);
        if (parsedScheme != null && parsedScheme.serializationFormat() == SerializationFormat.NONE && SUPPORTED_PROTOCOLS.contains((Object)parsedScheme.sessionProtocol())) {
            return parsedScheme;
        }
        throw new IllegalArgumentException("scheme : " + scheme + " (expected: one of " + SUPPORTED_PROTOCOLS + ')');
    }

    protected final WebClient buildWebClient() {
        ClientOptions options = this.buildOptions();
        ClientBuilderParams params = this.clientBuilderParams(options);
        ClientFactory factory = options.factory();
        return (WebClient)factory.newClient(params);
    }

    protected final ClientBuilderParams clientBuilderParams(ClientOptions options) {
        Objects.requireNonNull(options, "options");
        if (this.uri != null) {
            return ClientBuilderParams.of(this.uri, WebClient.class, options);
        }
        assert (this.scheme != null);
        assert (this.endpointGroup != null);
        return ClientBuilderParams.of(this.scheme, this.endpointGroup, this.path, WebClient.class, options);
    }

    @Override
    @Deprecated
    public AbstractWebClientBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        throw new UnsupportedOperationException("RPC decorator cannot be added to the web client builder.");
    }

    @Override
    @Deprecated
    public AbstractWebClientBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        throw new UnsupportedOperationException("RPC decorator cannot be added to the web client builder.");
    }
}

