/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractEventLoopEntry;
import com.linecorp.armeria.client.DefaultEventLoopScheduler;
import com.linecorp.armeria.client.HeapBasedEventLoopState;
import com.linecorp.armeria.client.OneEventLoopState;
import io.netty.channel.EventLoop;
import java.util.List;

abstract class AbstractEventLoopState {
    private final List<EventLoop> eventLoops;
    private final DefaultEventLoopScheduler scheduler;
    private long lastActivityTimeNanos = System.nanoTime();

    static AbstractEventLoopState of(List<EventLoop> eventLoops, int maxNumEventLoops, DefaultEventLoopScheduler scheduler) {
        if (maxNumEventLoops == 1) {
            return new OneEventLoopState(eventLoops, scheduler);
        }
        return new HeapBasedEventLoopState(eventLoops, maxNumEventLoops, scheduler);
    }

    AbstractEventLoopState(List<EventLoop> eventLoops, DefaultEventLoopScheduler scheduler) {
        this.eventLoops = eventLoops;
        this.scheduler = scheduler;
    }

    final List<EventLoop> eventLoops() {
        return this.eventLoops;
    }

    final DefaultEventLoopScheduler scheduler() {
        return this.scheduler;
    }

    final long lastActivityTimeNanos() {
        return this.lastActivityTimeNanos;
    }

    final void setLastActivityTimeNanos() {
        this.lastActivityTimeNanos = System.nanoTime();
    }

    abstract AbstractEventLoopEntry acquire();

    abstract void release(AbstractEventLoopEntry var1);

    abstract List<AbstractEventLoopEntry> entries();

    abstract int allActiveRequests();
}

