/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.DefaultDnsQueryLifecycleObserverFactory;
import com.linecorp.armeria.client.DnsCache;
import com.linecorp.armeria.client.NoopHostFileEntriesResolver;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.util.TransportType;
import com.linecorp.armeria.internal.client.dns.DnsUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.dns.AuthoritativeDnsServerCache;
import io.netty.resolver.dns.BiDnsQueryLifecycleObserverFactory;
import io.netty.resolver.dns.DnsCnameCache;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.resolver.dns.NoopAuthoritativeDnsServerCache;
import io.netty.resolver.dns.NoopDnsCache;
import io.netty.resolver.dns.NoopDnsCnameCache;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractDnsResolverBuilder {
    private static final long DEFAULT_QUERY_TIMEOUT_MILLIS = 5000L;
    private DnsCache dnsCache = DnsCache.ofDefault();
    private String cacheSpec = Flags.dnsCacheSpec();
    private int minTtl = 1;
    private int maxTtl = Integer.MAX_VALUE;
    private int negativeTtl;
    private boolean needsToCreateDnsCache;
    private boolean traceEnabled = true;
    private long queryTimeoutMillis = 5000L;
    private long queryTimeoutMillisForEachAttempt = -1L;
    private boolean recursionDesired = true;
    private int maxQueriesPerResolve = -1;
    private int maxPayloadSize = 4096;
    private boolean optResourceEnabled = true;
    private HostsFileEntriesResolver hostsFileEntriesResolver = HostsFileEntriesResolver.DEFAULT;
    private DnsServerAddressStreamProvider serverAddressStreamProvider = DnsServerAddressStreamProviders.platformDefault();
    @Nullable
    private DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory;
    private boolean dnsQueryMetricsEnabled = true;
    private List<String> searchDomains = DnsUtil.defaultSearchDomains();
    private int ndots = DnsUtil.defaultNdots();
    private boolean decodeIdn = true;
    @Nullable
    private MeterRegistry meterRegistry;

    protected AbstractDnsResolverBuilder() {
    }

    public AbstractDnsResolverBuilder traceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this;
    }

    public AbstractDnsResolverBuilder queryTimeout(Duration queryTimeout) {
        Objects.requireNonNull(queryTimeout, "queryTimeout");
        Preconditions.checkArgument(!queryTimeout.isNegative(), "queryTimeout: %s (expected: >= 0)", (Object)queryTimeout);
        return this.queryTimeoutMillis(queryTimeout.toMillis());
    }

    protected final long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public AbstractDnsResolverBuilder queryTimeoutMillis(long queryTimeoutMillis) {
        Preconditions.checkArgument(queryTimeoutMillis >= 0L, "queryTimeoutMillis: %s (expected: >= 0)", queryTimeoutMillis);
        this.queryTimeoutMillis = queryTimeoutMillis;
        return this;
    }

    public AbstractDnsResolverBuilder queryTimeoutForEachAttempt(Duration queryTimeoutForEachAttempt) {
        Objects.requireNonNull(queryTimeoutForEachAttempt, "queryTimeoutForEachAttempt");
        long queryTimeoutMillisForEachAttempt = queryTimeoutForEachAttempt.toMillis();
        Preconditions.checkArgument(queryTimeoutMillisForEachAttempt > 0L, "queryTimeoutForEachAttempt: %s (expected: > 0)", (Object)queryTimeoutForEachAttempt);
        return this.queryTimeoutMillisForEachAttempt(queryTimeoutMillisForEachAttempt);
    }

    public AbstractDnsResolverBuilder queryTimeoutMillisForEachAttempt(long queryTimeoutMillisForEachAttempt) {
        Preconditions.checkArgument(queryTimeoutMillisForEachAttempt > 0L, "queryTimeoutMillisForEachAttempt: %s (expected: > 0)", queryTimeoutMillisForEachAttempt);
        this.queryTimeoutMillisForEachAttempt = queryTimeoutMillisForEachAttempt;
        return this;
    }

    public AbstractDnsResolverBuilder recursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this;
    }

    public AbstractDnsResolverBuilder maxQueriesPerResolve(int maxQueriesPerResolve) {
        Preconditions.checkArgument(maxQueriesPerResolve > 0, "maxQueriesPerResolve: %s (expected: > 0)", maxQueriesPerResolve);
        this.maxQueriesPerResolve = maxQueriesPerResolve;
        return this;
    }

    public AbstractDnsResolverBuilder serverAddresses(InetSocketAddress ... serverAddresses) {
        return this.serverAddresses(ImmutableList.copyOf(Objects.requireNonNull(serverAddresses, "serverAddresses")));
    }

    public AbstractDnsResolverBuilder serverAddresses(Iterable<InetSocketAddress> serverAddresses) {
        DnsServerAddresses addrs = DnsServerAddresses.sequential(serverAddresses);
        return this.serverAddressStreamProvider(hostname -> addrs.stream());
    }

    protected final DnsServerAddressStreamProvider serverAddressStreamProvider() {
        return this.serverAddressStreamProvider;
    }

    public AbstractDnsResolverBuilder serverAddressStreamProvider(DnsServerAddressStreamProvider serverAddressStreamProvider) {
        Objects.requireNonNull(serverAddressStreamProvider, "serverAddressStreamProvider");
        this.serverAddressStreamProvider = serverAddressStreamProvider;
        return this;
    }

    @Deprecated
    public AbstractDnsResolverBuilder dnsServerAddressStreamProvider(DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        return this.serverAddressStreamProvider(dnsServerAddressStreamProvider);
    }

    public AbstractDnsResolverBuilder maxPayloadSize(int maxPayloadSize) {
        Preconditions.checkArgument(maxPayloadSize > 0, "maxPayloadSize: %s (expected: > 0)", maxPayloadSize);
        this.maxPayloadSize = maxPayloadSize;
        return this;
    }

    public AbstractDnsResolverBuilder optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    protected final HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    public AbstractDnsResolverBuilder hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        return this;
    }

    public AbstractDnsResolverBuilder dnsQueryLifecycleObserverFactory(DnsQueryLifecycleObserverFactory observerFactory) {
        Objects.requireNonNull(observerFactory, "observerFactory");
        this.dnsQueryLifecycleObserverFactory = observerFactory;
        return this;
    }

    @Deprecated
    public AbstractDnsResolverBuilder disableDnsQueryMetrics() {
        return this.enableDnsQueryMetrics(false);
    }

    public AbstractDnsResolverBuilder enableDnsQueryMetrics(boolean enable) {
        this.dnsQueryMetricsEnabled = enable;
        return this;
    }

    protected final List<String> searchDomains() {
        return this.searchDomains;
    }

    public AbstractDnsResolverBuilder searchDomains(String ... searchDomains) {
        Objects.requireNonNull(searchDomains, "searchDomains");
        return this.searchDomains(ImmutableList.copyOf(searchDomains));
    }

    public AbstractDnsResolverBuilder searchDomains(Iterable<String> searchDomains) {
        Objects.requireNonNull(searchDomains, "searchDomains");
        this.searchDomains = ImmutableList.copyOf(searchDomains);
        return this;
    }

    protected final int ndots() {
        return this.ndots;
    }

    public AbstractDnsResolverBuilder ndots(int ndots) {
        Preconditions.checkArgument(ndots >= 0, "ndots: %s (expected: >= 0)", ndots);
        this.ndots = ndots;
        return this;
    }

    public AbstractDnsResolverBuilder decodeIdn(boolean decodeIdn) {
        this.decodeIdn = decodeIdn;
        return this;
    }

    @Nullable
    protected final MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    public AbstractDnsResolverBuilder meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    protected final String cacheSpec() {
        return this.cacheSpec;
    }

    public AbstractDnsResolverBuilder cacheSpec(String cacheSpec) {
        Objects.requireNonNull(cacheSpec, "cacheSpec");
        this.cacheSpec = cacheSpec;
        this.needsToCreateDnsCache = true;
        return this;
    }

    protected final int minTtl() {
        return this.minTtl;
    }

    protected final int maxTtl() {
        return this.maxTtl;
    }

    public AbstractDnsResolverBuilder ttl(int minTtl, int maxTtl) {
        Preconditions.checkArgument(minTtl > 0 && minTtl <= maxTtl, "minTtl: %s, maxTtl: %s (expected: 1 <= minTtl <= maxTtl)", minTtl, maxTtl);
        this.minTtl = minTtl;
        this.maxTtl = maxTtl;
        this.needsToCreateDnsCache = true;
        return this;
    }

    protected final int negativeTtl() {
        return this.negativeTtl;
    }

    public AbstractDnsResolverBuilder negativeTtl(int negativeTtl) {
        Preconditions.checkArgument(negativeTtl >= 0, "negativeTtl: %s (expected: >= 0)", negativeTtl);
        this.needsToCreateDnsCache = true;
        this.negativeTtl = negativeTtl;
        return this;
    }

    public AbstractDnsResolverBuilder dnsCache(DnsCache dnsCache) {
        Objects.requireNonNull(dnsCache, "dnsCache");
        this.dnsCache = dnsCache;
        return this;
    }

    protected final DnsCache maybeCreateDnsCache() {
        if (this.needsToCreateDnsCache && this.dnsCache != DnsCache.ofDefault()) {
            throw new IllegalStateException("Cannot set dnsCache() with cacheSpec(), ttl(), or negativeTtl().");
        }
        MeterRegistry meterRegistry = (MeterRegistry)MoreObjects.firstNonNull(this.meterRegistry, Metrics.globalRegistry);
        if (this.needsToCreateDnsCache) {
            return DnsCache.builder().cacheSpec(this.cacheSpec).ttl(this.minTtl, this.maxTtl).negativeTtl(this.negativeTtl).meterRegistry(meterRegistry).build();
        }
        return this.dnsCache;
    }

    protected final Consumer<DnsNameResolverBuilder> buildConfigurator(EventLoopGroup eventLoopGroup) {
        if (this.queryTimeoutMillisForEachAttempt > -1L) {
            Preconditions.checkState(this.queryTimeoutMillis >= this.queryTimeoutMillisForEachAttempt, "queryTimeoutMillis: %s, queryTimeoutMillisForEachAttempt: %s (expected: queryTimeoutMillis >= queryTimeoutMillisForEachAttempt)", this.queryTimeoutMillis, this.queryTimeoutMillisForEachAttempt);
        }
        MeterRegistry meterRegistry = (MeterRegistry)MoreObjects.firstNonNull(this.meterRegistry, Metrics.globalRegistry);
        boolean traceEnabled = this.traceEnabled;
        long queryTimeoutMillis = this.queryTimeoutMillis;
        long queryTimeoutMillisForEachAttempt = this.queryTimeoutMillisForEachAttempt;
        boolean recursionDesired = this.recursionDesired;
        int maxQueriesPerResolve = this.maxQueriesPerResolve;
        int maxPayloadSize = this.maxPayloadSize;
        boolean optResourceEnabled = this.optResourceEnabled;
        DnsServerAddressStreamProvider serverAddressStreamProvider = this.serverAddressStreamProvider;
        DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory = this.dnsQueryLifecycleObserverFactory;
        boolean dnsQueryMetricsEnabled = this.dnsQueryMetricsEnabled;
        boolean decodeIdn = this.decodeIdn;
        return builder -> {
            builder.channelType(TransportType.datagramChannelType(eventLoopGroup)).socketChannelType(TransportType.socketChannelType(eventLoopGroup)).resolveCache((io.netty.resolver.dns.DnsCache)NoopDnsCache.INSTANCE).authoritativeDnsServerCache((AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE).cnameCache((DnsCnameCache)NoopDnsCnameCache.INSTANCE).traceEnabled(traceEnabled).completeOncePreferredResolved(true).recursionDesired(recursionDesired).maxQueriesPerResolve(maxQueriesPerResolve).maxPayloadSize(maxPayloadSize).optResourceEnabled(optResourceEnabled).hostsFileEntriesResolver((HostsFileEntriesResolver)NoopHostFileEntriesResolver.INSTANCE).nameServerProvider(serverAddressStreamProvider).searchDomains(ImmutableList.of()).decodeIdn(decodeIdn);
            if (queryTimeoutMillisForEachAttempt > 0L) {
                builder.queryTimeoutMillis(queryTimeoutMillisForEachAttempt);
            } else if (queryTimeoutMillis == 0L) {
                builder.queryTimeoutMillis(Long.MAX_VALUE);
            } else {
                builder.queryTimeoutMillis(queryTimeoutMillis);
            }
            DnsQueryLifecycleObserverFactory observerFactory = dnsQueryLifecycleObserverFactory;
            if (dnsQueryMetricsEnabled) {
                DefaultDnsQueryLifecycleObserverFactory defaultObserverFactory = new DefaultDnsQueryLifecycleObserverFactory(meterRegistry, new MeterIdPrefix("armeria.client.dns.queries"));
                observerFactory = observerFactory == null ? defaultObserverFactory : new BiDnsQueryLifecycleObserverFactory(observerFactory, (DnsQueryLifecycleObserverFactory)defaultObserverFactory);
            }
            if (observerFactory != null) {
                builder.dnsQueryLifecycleObserverFactory(observerFactory);
            }
        };
    }
}

