/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.metadata.$AutoValue_IndexRule;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class IndexRule
extends NamedSchema<BanyandbDatabase.IndexRule> {
    abstract ImmutableList<String> tags();

    abstract IndexType indexType();

    abstract IndexLocation indexLocation();

    abstract Builder toBuilder();

    public final IndexRule withGroup(String group) {
        return this.toBuilder().setGroup(group).build();
    }

    public static IndexRule create(String name, IndexType indexType, IndexLocation indexLocation) {
        return new $AutoValue_IndexRule.Builder().setName(name).setTags((ImmutableList<String>)ImmutableList.of((Object)name)).setIndexType(indexType).setIndexLocation(indexLocation).build();
    }

    @VisibleForTesting
    static IndexRule create(String group, String name, IndexType indexType, IndexLocation indexLocation) {
        return new $AutoValue_IndexRule.Builder().setGroup(group).setName(name).setTags((ImmutableList<String>)ImmutableList.of((Object)name)).setIndexType(indexType).setIndexLocation(indexLocation).build();
    }

    @Override
    public BanyandbDatabase.IndexRule serialize() {
        BanyandbDatabase.IndexRule.Builder b = BanyandbDatabase.IndexRule.newBuilder().setMetadata(this.buildMetadata()).addAllTags((Iterable<String>)this.tags()).setLocation(this.indexLocation().location).setType(this.indexType().type);
        if (this.updatedAt() != null) {
            b.setUpdatedAt(TimeUtils.buildTimestamp(this.updatedAt()));
        }
        return b.build();
    }

    public static IndexRule fromProtobuf(BanyandbDatabase.IndexRule pb) {
        IndexType indexType = IndexType.fromProtobuf(pb.getType());
        IndexLocation indexLocation = IndexLocation.fromProtobuf(pb.getLocation());
        return new $AutoValue_IndexRule.Builder().setGroup(pb.getMetadata().getGroup()).setName(pb.getMetadata().getName()).setUpdatedAt(TimeUtils.parseTimestamp(pb.getUpdatedAt())).setIndexLocation(indexLocation).setIndexType(indexType).setTags((ImmutableList<String>)ImmutableList.copyOf((Collection)pb.getTagsList())).build();
    }

    public static enum IndexLocation {
        SERIES(BanyandbDatabase.IndexRule.Location.LOCATION_SERIES),
        GLOBAL(BanyandbDatabase.IndexRule.Location.LOCATION_GLOBAL);

        private final BanyandbDatabase.IndexRule.Location location;

        private static IndexLocation fromProtobuf(BanyandbDatabase.IndexRule.Location loc) {
            switch (loc) {
                case LOCATION_GLOBAL: {
                    return GLOBAL;
                }
                case LOCATION_SERIES: {
                    return SERIES;
                }
            }
            throw new IllegalArgumentException("unrecognized index location");
        }

        private IndexLocation(BanyandbDatabase.IndexRule.Location location) {
            this.location = location;
        }
    }

    public static enum IndexType {
        TREE(BanyandbDatabase.IndexRule.Type.TYPE_TREE),
        INVERTED(BanyandbDatabase.IndexRule.Type.TYPE_INVERTED);

        private final BanyandbDatabase.IndexRule.Type type;

        private static IndexType fromProtobuf(BanyandbDatabase.IndexRule.Type type) {
            switch (type) {
                case TYPE_TREE: {
                    return TREE;
                }
                case TYPE_INVERTED: {
                    return INVERTED;
                }
            }
            throw new IllegalArgumentException("unrecognized index type");
        }

        private IndexType(BanyandbDatabase.IndexRule.Type type) {
            this.type = type;
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setGroup(String var1);

        abstract Builder setName(String var1);

        abstract Builder setTags(ImmutableList<String> var1);

        abstract Builder setIndexType(IndexType var1);

        abstract Builder setIndexLocation(IndexLocation var1);

        abstract Builder setUpdatedAt(ZonedDateTime var1);

        abstract IndexRule build();
    }
}

