/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.v1.client.metadata.AutoValue_Group;
import org.apache.skywalking.banyandb.v1.client.metadata.Catalog;
import org.apache.skywalking.banyandb.v1.client.metadata.Duration;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class Group
extends NamedSchema<BanyandbCommon.Group> {
    abstract Catalog catalog();

    abstract int shardNum();

    @Nullable
    abstract Integer blockNum();

    abstract Duration ttl();

    public static Group create(String name, Catalog catalog, int shardNum, int blockNum, Duration ttl) {
        return new AutoValue_Group(null, name, null, catalog, shardNum, blockNum, ttl);
    }

    public static Group create(String name, Catalog catalog, int shardNum, int blockNum, Duration ttl, ZonedDateTime updatedAt) {
        return new AutoValue_Group(null, name, updatedAt, catalog, shardNum, blockNum, ttl);
    }

    @Override
    public BanyandbCommon.Group serialize() {
        return BanyandbCommon.Group.newBuilder().setMetadata(this.buildMetadata().toBuilder()).setCatalog(this.catalog().getCatalog()).setResourceOpts(BanyandbCommon.ResourceOpts.newBuilder().setShardNum(this.shardNum()).setBlockNum(this.blockNum()).setTtl(this.ttl().format()).build()).build();
    }

    public static Group fromProtobuf(BanyandbCommon.Group group) {
        Catalog catalog = Catalog.UNSPECIFIED;
        switch (group.getCatalog()) {
            case CATALOG_STREAM: {
                catalog = Catalog.STREAM;
                break;
            }
            case CATALOG_MEASURE: {
                catalog = Catalog.MEASURE;
            }
        }
        return new AutoValue_Group(null, group.getMetadata().getName(), TimeUtils.parseTimestamp(group.getUpdatedAt()), catalog, group.getResourceOpts().getShardNum(), group.getResourceOpts().getBlockNum(), Duration.parse(group.getResourceOpts().getTtl()));
    }
}

