/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(((?<day>\\d+)d)?((?<hour>\\d+)h)?((?<minute>\\d+)m)?|0)");
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long MINUTES_PER_DAY = 1440L;
    private volatile String text;
    private final long minutes;

    private Duration(long minutes) {
        this.minutes = minutes;
    }

    public String format() {
        long weeks;
        if (!Strings.isNullOrEmpty((String)this.text)) {
            return this.text;
        }
        StringBuilder builder = new StringBuilder();
        long minutes = this.minutes;
        if (minutes >= 1440L) {
            weeks = minutes / 1440L;
            builder.append(weeks).append("d");
            minutes %= 1440L;
        }
        if (minutes >= 60L) {
            weeks = minutes / 60L;
            builder.append(weeks).append("h");
            minutes %= 60L;
        }
        if (minutes > 0L) {
            builder.append(minutes).append("m");
        }
        this.text = builder.toString();
        return this.text;
    }

    public Duration add(Duration duration) {
        return new Duration(this.minutes + duration.minutes);
    }

    public static Duration parse(String text) {
        String minutes;
        String hours;
        if (Strings.isNullOrEmpty((String)text)) {
            return new Duration(0L);
        }
        Matcher matcher = DURATION_PATTERN.matcher(text);
        if (!matcher.find()) {
            return new Duration(0L);
        }
        long total = 0L;
        String days = matcher.group("day");
        if (!Strings.isNullOrEmpty((String)days)) {
            total += Long.parseLong(days) * 1440L;
        }
        if (!Strings.isNullOrEmpty((String)(hours = matcher.group("hour")))) {
            total += Long.parseLong(hours) * 60L;
        }
        if (!Strings.isNullOrEmpty((String)(minutes = matcher.group("minute")))) {
            total += Long.parseLong(minutes);
        }
        return new Duration(total);
    }

    public static Duration ofMinutes(long minutes) {
        return new Duration(minutes);
    }

    public static Duration ofHours(long hours) {
        return new Duration(hours * 60L);
    }

    public static Duration ofDays(long days) {
        return Duration.ofHours(days * 1440L);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.minutes == other.minutes;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Duration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minutes = this.minutes;
        result = result * 59 + (int)($minutes >>> 32 ^ $minutes);
        return result;
    }
}

