/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.grpc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCStreamServiceStatus {
    private static final Logger log = LoggerFactory.getLogger(GRPCStreamServiceStatus.class);
    private volatile boolean status;

    public GRPCStreamServiceStatus(boolean status) {
        this.status = status;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void finished() {
        this.status = true;
    }

    public void wait4Finish() {
        long recheckCycle = 5L;
        long hasWaited = 0L;
        long maxCycle = 30000L;
        while (!this.status) {
            this.try2Sleep(recheckCycle);
            hasWaited += recheckCycle;
            if (recheckCycle >= maxCycle) {
                log.warn("Collector traceSegment service doesn't response in {} seconds.", (Object)(hasWaited / 1000L));
                continue;
            }
            recheckCycle = Math.min(recheckCycle * 2L, maxCycle);
        }
    }

    private void try2Sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

