/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import java.util.List;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;

public abstract class Value<T> {
    protected final T value;

    protected Value(T value) {
        this.value = value;
    }

    public static Serializable<BanyandbModel.TagValue> stringTagValue(String val) {
        if (val == null) {
            return Value.nullTagValue();
        }
        return new StringTagValue(val);
    }

    static Serializable<BanyandbModel.TagValue> idTagValue(String val) {
        if (Strings.isNullOrEmpty((String)val)) {
            throw new NullPointerException();
        }
        return new IDTagValue(val);
    }

    public static Serializable<BanyandbModel.TagValue> longTagValue(long val) {
        return new LongTagValue(val);
    }

    public static Serializable<BanyandbModel.TagValue> stringArrayTagValue(List<String> val) {
        return new StringArrayTagValue(val);
    }

    public static Serializable<BanyandbModel.TagValue> binaryTagValue(byte[] bytes) {
        return new BinaryTagValue(ByteString.copyFrom((byte[])bytes));
    }

    public static Serializable<BanyandbModel.TagValue> longArrayTag(List<Long> val) {
        return new LongArrayTagValue(val);
    }

    public static Serializable<BanyandbModel.TagValue> nullTagValue() {
        return NullTagValue.INSTANCE;
    }

    public static Serializable<BanyandbModel.FieldValue> stringFieldValue(String val) {
        if (Strings.isNullOrEmpty((String)val)) {
            return Value.nullFieldValue();
        }
        return new StringFieldValue(val);
    }

    public static Serializable<BanyandbModel.FieldValue> nullFieldValue() {
        return NullFieldValue.INSTANCE;
    }

    public static Serializable<BanyandbModel.FieldValue> longFieldValue(long val) {
        return new LongFieldValue(val);
    }

    public static Serializable<BanyandbModel.FieldValue> binaryFieldValue(byte[] bytes) {
        return new BinaryFieldValue(ByteString.copyFrom((byte[])bytes));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Value;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public T getValue() {
        return this.value;
    }

    public static class BinaryFieldValue
    extends Value<ByteString>
    implements Serializable<BanyandbModel.FieldValue> {
        public BinaryFieldValue(ByteString byteString) {
            super(byteString);
        }

        @Override
        public BanyandbModel.FieldValue serialize() {
            return BanyandbModel.FieldValue.newBuilder().setBinaryData((ByteString)this.value).build();
        }
    }

    public static class LongFieldValue
    extends Value<Long>
    implements Serializable<BanyandbModel.FieldValue> {
        private LongFieldValue(Long value) {
            super(value);
        }

        @Override
        public BanyandbModel.FieldValue serialize() {
            return BanyandbModel.FieldValue.newBuilder().setInt(BanyandbModel.Int.newBuilder().setValue((Long)this.value)).build();
        }
    }

    public static class NullFieldValue
    extends Value<Object>
    implements Serializable<BanyandbModel.FieldValue> {
        private static final NullFieldValue INSTANCE = new NullFieldValue();

        private NullFieldValue() {
            super(null);
        }

        @Override
        public BanyandbModel.FieldValue serialize() {
            return BanyandbModel.FieldValue.newBuilder().setNull(NullValue.NULL_VALUE).build();
        }
    }

    public static class StringFieldValue
    extends Value<String>
    implements Serializable<BanyandbModel.FieldValue> {
        private StringFieldValue(String value) {
            super(value);
        }

        @Override
        public BanyandbModel.FieldValue serialize() {
            return BanyandbModel.FieldValue.newBuilder().setStr(BanyandbModel.Str.newBuilder().setValue((String)this.value)).build();
        }
    }

    public static class BinaryTagValue
    extends Value<ByteString>
    implements Serializable<BanyandbModel.TagValue> {
        public BinaryTagValue(ByteString byteString) {
            super(byteString);
        }

        @Override
        public BanyandbModel.TagValue serialize() {
            return BanyandbModel.TagValue.newBuilder().setBinaryData((ByteString)this.value).build();
        }
    }

    public static class LongArrayTagValue
    extends Value<List<Long>>
    implements Serializable<BanyandbModel.TagValue> {
        private LongArrayTagValue(List<Long> value) {
            super(value);
        }

        @Override
        public BanyandbModel.TagValue serialize() {
            return BanyandbModel.TagValue.newBuilder().setIntArray(BanyandbModel.IntArray.newBuilder().addAllValue((Iterable)this.value)).build();
        }
    }

    public static class LongTagValue
    extends Value<Long>
    implements Serializable<BanyandbModel.TagValue> {
        private LongTagValue(Long value) {
            super(value);
        }

        @Override
        public BanyandbModel.TagValue serialize() {
            return BanyandbModel.TagValue.newBuilder().setInt(BanyandbModel.Int.newBuilder().setValue((Long)this.value)).build();
        }
    }

    public static class IDTagValue
    extends Value<String>
    implements Serializable<BanyandbModel.TagValue> {
        private IDTagValue(String value) {
            super(value);
        }

        @Override
        public BanyandbModel.TagValue serialize() {
            return BanyandbModel.TagValue.newBuilder().setId(BanyandbModel.ID.newBuilder().setValue((String)this.value)).build();
        }
    }

    public static class StringArrayTagValue
    extends Value<List<String>>
    implements Serializable<BanyandbModel.TagValue> {
        private StringArrayTagValue(List<String> value) {
            super(value);
        }

        @Override
        public BanyandbModel.TagValue serialize() {
            return BanyandbModel.TagValue.newBuilder().setStrArray(BanyandbModel.StrArray.newBuilder().addAllValue((Iterable)this.value)).build();
        }
    }

    public static class StringTagValue
    extends Value<String>
    implements Serializable<BanyandbModel.TagValue> {
        private StringTagValue(String value) {
            super(value);
        }

        @Override
        public BanyandbModel.TagValue serialize() {
            return BanyandbModel.TagValue.newBuilder().setStr(BanyandbModel.Str.newBuilder().setValue((String)this.value)).build();
        }
    }

    public static class NullTagValue
    extends Value<Object>
    implements Serializable<BanyandbModel.TagValue> {
        private static final NullTagValue INSTANCE = new NullTagValue();

        private NullTagValue() {
            super(null);
        }

        @Override
        public BanyandbModel.TagValue serialize() {
            return BanyandbModel.TagValue.newBuilder().setNull(NullValue.NULL_VALUE).build();
        }
    }
}

