/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import io.grpc.stub.StreamObserver;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;
import org.apache.skywalking.banyandb.stream.v1.StreamServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.AbstractBulkWriteProcessor;
import org.apache.skywalking.banyandb.v1.client.grpc.GRPCStreamServiceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StreamBulkWriteProcessor
extends AbstractBulkWriteProcessor<BanyandbStream.WriteRequest, StreamServiceGrpc.StreamServiceStub> {
    private static final Logger log = LoggerFactory.getLogger(StreamBulkWriteProcessor.class);

    protected StreamBulkWriteProcessor(StreamServiceGrpc.StreamServiceStub serviceStub, int maxBulkSize, int flushInterval, int concurrency) {
        super(serviceStub, "StreamBulkWriteProcessor", maxBulkSize, flushInterval, concurrency);
    }

    @Override
    protected StreamObserver<BanyandbStream.WriteRequest> buildStreamObserver(StreamServiceGrpc.StreamServiceStub stub, final GRPCStreamServiceStatus status) {
        return stub.write(new StreamObserver<BanyandbStream.WriteResponse>(){

            public void onNext(BanyandbStream.WriteResponse writeResponse) {
            }

            public void onError(Throwable t) {
                status.finished();
                log.error("Error occurs in flushing streams", t);
            }

            public void onCompleted() {
                status.finished();
            }
        });
    }
}

