/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;

public class RowEntity {
    protected String id;
    protected final long timestamp;
    protected final Map<String, Object> tags;

    public static RowEntity create(BanyandbStream.Element element) {
        RowEntity rowEntity = new RowEntity(element.getTimestamp(), element.getTagFamiliesList());
        rowEntity.id = element.getElementId();
        return rowEntity;
    }

    protected RowEntity(Timestamp ts, List<BanyandbModel.TagFamily> tagFamilyList) {
        this.timestamp = ts.getSeconds() * 1000L + (long)(ts.getNanos() / 1000000);
        this.tags = new HashMap<String, Object>();
        for (BanyandbModel.TagFamily tagFamily : tagFamilyList) {
            for (BanyandbModel.Tag tag : tagFamily.getTagsList()) {
                Object val = this.convertToJavaType(tag.getValue());
                if (val == null) continue;
                this.tags.put(tag.getKey(), val);
            }
        }
    }

    public <T> T getTagValue(String tagName) {
        return (T)this.tags.get(tagName);
    }

    private Object convertToJavaType(BanyandbModel.TagValue tagValue) {
        switch (tagValue.getValueCase()) {
            case INT: {
                return tagValue.getInt().getValue();
            }
            case STR: {
                return tagValue.getStr().getValue();
            }
            case NULL: {
                return null;
            }
            case INT_ARRAY: {
                return tagValue.getIntArray().getValueList();
            }
            case STR_ARRAY: {
                return tagValue.getStrArray().getValueList();
            }
            case BINARY_DATA: {
                return tagValue.getBinaryData().toByteArray();
            }
            case ID: {
                return tagValue.getId().getValue();
            }
        }
        throw new IllegalStateException("illegal type of TagValue");
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }
}

