/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.Timestamp;
import java.util.LinkedList;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.AbstractWrite;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;

public class MeasureWrite
extends AbstractWrite<BanyandbMeasure.WriteRequest> {
    private final Object[] fields;

    public MeasureWrite(String group, String name, long timestamp) {
        super(group, name, timestamp);
        this.fields = new Object[this.entityMetadata.getTotalFields()];
    }

    public MeasureWrite field(String fieldName, Serializable<BanyandbModel.FieldValue> fieldVal) {
        int index = this.entityMetadata.findFieldInfo(fieldName);
        this.fields[index] = fieldVal;
        return this;
    }

    public MeasureWrite tag(String tagName, Serializable<BanyandbModel.TagValue> tagValue) throws BanyanDBException {
        return (MeasureWrite)super.tag(tagName, tagValue);
    }

    public MeasureWrite setID(String idValue) throws BanyanDBException {
        return this.tag("id", (Serializable)TagAndValue.idTagValue(idValue));
    }

    @Override
    protected BanyandbMeasure.WriteRequest build(BanyandbCommon.Metadata metadata, Timestamp ts) {
        BanyandbMeasure.WriteRequest.Builder builder = BanyandbMeasure.WriteRequest.newBuilder();
        builder.setMetadata(metadata);
        BanyandbMeasure.DataPointValue.Builder datapointValueBuilder = BanyandbMeasure.DataPointValue.newBuilder();
        datapointValueBuilder.setTimestamp(ts);
        int lastFamilyOffset = 0;
        for (int tagsPerFamily : this.entityMetadata.getTagFamilyCapacity()) {
            BanyandbModel.TagFamilyForWrite.Builder b = BanyandbModel.TagFamilyForWrite.newBuilder();
            boolean firstNonNullTagFound = false;
            LinkedList tags = new LinkedList();
            for (int j = tagsPerFamily - 1; j >= 0; --j) {
                Object obj = this.tags[lastFamilyOffset + j];
                if (obj == null) {
                    if (!firstNonNullTagFound) continue;
                    b.addTags(TagAndValue.nullTagValue().serialize());
                    continue;
                }
                firstNonNullTagFound = true;
                tags.addFirst(((Serializable)obj).serialize());
            }
            lastFamilyOffset += tagsPerFamily;
            datapointValueBuilder.addTagFamilies(b.addAllTags(tags).build());
        }
        for (int i = 0; i < this.entityMetadata.getTotalFields(); ++i) {
            Object obj = this.fields[i];
            if (obj != null) {
                datapointValueBuilder.addFields((BanyandbModel.FieldValue)((Serializable)obj).serialize());
                continue;
            }
            datapointValueBuilder.addFields(TagAndValue.nullFieldValue().serialize());
        }
        builder.setDataPoint(datapointValueBuilder);
        return builder.build();
    }
}

