/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.RowEntity;

public class DataPoint
extends RowEntity {
    private final Map<String, Object> fields;

    public static DataPoint create(BanyandbMeasure.DataPoint dataPoint) {
        DataPoint dp = new DataPoint(dataPoint);
        dp.id = (String)dp.getTagValue("id");
        return dp;
    }

    private DataPoint(BanyandbMeasure.DataPoint dataPoint) {
        super(dataPoint.getTimestamp(), dataPoint.getTagFamiliesList());
        this.fields = new HashMap<String, Object>(dataPoint.getFieldsCount());
        for (BanyandbMeasure.DataPoint.Field f : dataPoint.getFieldsList()) {
            this.fields.put(f.getName(), this.convertToJavaType(f.getValue()));
        }
    }

    public <T> T getFieldValue(String fieldName) {
        return (T)this.fields.get(fieldName);
    }

    private Object convertToJavaType(BanyandbModel.FieldValue fieldValue) {
        switch (fieldValue.getValueCase()) {
            case INT: {
                return fieldValue.getInt().getValue();
            }
            case STR: {
                return fieldValue.getStr().getValue();
            }
            case NULL: {
                return null;
            }
            case BINARY_DATA: {
                return fieldValue.getBinaryData().toByteArray();
            }
        }
        throw new IllegalStateException("illegal type of FieldValue");
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }
}

