/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InvalidReferenceException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;

public abstract class AbstractQuery<T> {
    protected final String group;
    protected final String name;
    protected final TimestampRange timestampRange;
    protected final List<PairQueryCondition<?>> conditions;
    protected final Set<String> tagProjections;
    protected final MetadataCache.EntityMetadata metadata;

    public AbstractQuery(String group, String name, TimestampRange timestampRange, Set<String> tagProjections) {
        this.group = group;
        this.name = name;
        this.timestampRange = timestampRange;
        this.conditions = new ArrayList(10);
        this.tagProjections = tagProjections;
        this.metadata = MetadataCache.INSTANCE.findMetadata(this.group, this.name);
    }

    public AbstractQuery<T> and(PairQueryCondition<?> condition) {
        this.conditions.add(condition);
        return this;
    }

    abstract T build() throws BanyanDBException;

    protected BanyandbCommon.Metadata buildMetadata() {
        return BanyandbCommon.Metadata.newBuilder().setGroup(this.group).setName(this.name).build();
    }

    protected List<BanyandbModel.Criteria> buildCriteria() throws BanyanDBException {
        ArrayList<BanyandbModel.Criteria> criteriaList = new ArrayList<BanyandbModel.Criteria>();
        HashMap<String, List> groupedConditions = new HashMap<String, List>();
        for (PairQueryCondition<?> pairQueryCondition : this.conditions) {
            String tagFamilyName = this.metadata.findTagInfo(pairQueryCondition.getTagName()).orElseThrow(() -> InvalidReferenceException.fromInvalidTag(condition.getTagName())).getTagFamilyName();
            List conditionList = groupedConditions.computeIfAbsent(tagFamilyName, key -> new ArrayList());
            conditionList.add(pairQueryCondition);
        }
        for (Map.Entry entry : groupedConditions.entrySet()) {
            List conditionList = ((List)entry.getValue()).stream().map(PairQueryCondition::build).collect(Collectors.toList());
            BanyandbModel.Criteria criteria = BanyandbModel.Criteria.newBuilder().setTagFamilyName((String)entry.getKey()).addAllConditions(conditionList).build();
            criteriaList.add(criteria);
        }
        return criteriaList;
    }

    protected BanyandbModel.TagProjection buildTagProjections() throws BanyanDBException {
        return this.buildTagProjections(this.tagProjections);
    }

    protected BanyandbModel.TagProjection buildTagProjections(Iterable<String> tagProjections) throws BanyanDBException {
        ArrayListMultimap projectionMap = ArrayListMultimap.create();
        for (String tagName : tagProjections) {
            Optional<MetadataCache.TagInfo> tagInfo = this.metadata.findTagInfo(tagName);
            if (!tagInfo.isPresent()) {
                throw InvalidReferenceException.fromInvalidTag(tagName);
            }
            projectionMap.put((Object)tagInfo.get().getTagFamilyName(), (Object)tagName);
        }
        BanyandbModel.TagProjection.Builder b = BanyandbModel.TagProjection.newBuilder();
        for (String tagFamilyName : projectionMap.keySet()) {
            b.addTagFamilies(BanyandbModel.TagProjection.TagFamily.newBuilder().setName(tagFamilyName).addAllTags(projectionMap.get((Object)tagFamilyName)).build());
        }
        return b.build();
    }

    MetadataCache.EntityMetadata getMetadata() {
        return this.metadata;
    }

    public static enum Sort {
        ASC,
        DESC;

    }

    public static class OrderBy {
        private final String indexRuleName;
        private final Sort type;

        BanyandbModel.QueryOrder build() {
            BanyandbModel.QueryOrder.Builder builder = BanyandbModel.QueryOrder.newBuilder();
            builder.setIndexRuleName(this.indexRuleName);
            builder.setSort(Sort.DESC.equals((Object)this.type) ? BanyandbModel.Sort.SORT_DESC : BanyandbModel.Sort.SORT_ASC);
            return builder.build();
        }

        public OrderBy(String indexRuleName, Sort type) {
            this.indexRuleName = indexRuleName;
            this.type = type;
        }
    }
}

