/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.banyandb.v1.client.AbstractWrite;
import org.apache.skywalking.banyandb.v1.client.BulkWriteProcessor;
import org.apache.skywalking.banyandb.v1.client.grpc.GRPCStreamServiceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBulkWriteProcessor<REQ extends GeneratedMessageV3, STUB extends AbstractAsyncStub<STUB>>
extends BulkWriteProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractBulkWriteProcessor.class);
    private final STUB stub;

    protected AbstractBulkWriteProcessor(STUB stub, String processorName, int maxBulkSize, int flushInterval, int concurrency) {
        super(processorName, maxBulkSize, flushInterval, concurrency);
        this.stub = stub;
    }

    public void add(AbstractWrite<REQ> writeEntity) {
        this.buffer.produce(writeEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush(List data) {
        GRPCStreamServiceStatus status = new GRPCStreamServiceStatus(false);
        StreamObserver writeRequestStreamObserver = this.buildStreamObserver((AbstractAsyncStub)this.stub.withDeadlineAfter((long)this.flushInterval, TimeUnit.SECONDS), status);
        try {
            data.forEach(write -> {
                Object request = ((AbstractWrite)write).build();
                writeRequestStreamObserver.onNext(request);
            });
        }
        catch (Throwable t) {
            log.error("Transform and send request to BanyanDB fail.", t);
        }
        finally {
            writeRequestStreamObserver.onCompleted();
        }
        status.wait4Finish();
    }

    protected abstract StreamObserver<REQ> buildStreamObserver(STUB var1, GRPCStreamServiceStatus var2);
}

