/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.consul;

import com.google.common.net.HostAndPort;
import com.orbitz.consul.Consul;
import com.orbitz.consul.ConsulException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.cluster.plugin.consul.ClusterModuleConsulConfig;
import org.apache.skywalking.oap.server.cluster.plugin.consul.ConsulCoordinator;
import org.apache.skywalking.oap.server.core.cluster.ClusterModule;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.Address;
import org.apache.skywalking.oap.server.library.util.ConnectStringParseException;
import org.apache.skywalking.oap.server.library.util.ConnectUtils;

public class ClusterModuleConsulProvider
extends ModuleProvider {
    private final ClusterModuleConsulConfig config = new ClusterModuleConsulConfig();
    private Consul client;

    public String name() {
        return "consul";
    }

    public Class module() {
        return ClusterModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        try {
            List addressList = ConnectUtils.parse((String)this.config.getHostPort());
            ArrayList<HostAndPort> hostAndPorts = new ArrayList<HostAndPort>();
            for (Address address : addressList) {
                hostAndPorts.add(HostAndPort.fromParts((String)address.getHost(), (int)address.getPort()));
            }
            Consul.Builder consulBuilder = Consul.builder().withConnectTimeoutMillis(3000L);
            if (StringUtils.isNotEmpty((CharSequence)this.config.getAclToken())) {
                consulBuilder.withAclToken(this.config.getAclToken());
            }
            this.client = hostAndPorts.size() > 1 ? consulBuilder.withMultipleHostAndPort(hostAndPorts, 5000L).build() : consulBuilder.withHostAndPort((HostAndPort)hostAndPorts.get(0)).build();
        }
        catch (ConsulException | ConnectStringParseException e) {
            throw new ModuleStartException(e.getMessage(), e);
        }
        ConsulCoordinator coordinator = new ConsulCoordinator((ModuleDefineHolder)this.getManager(), this.config, this.client);
        this.registerServiceImplementation(ClusterRegister.class, (Service)coordinator);
        this.registerServiceImplementation(ClusterNodesQuery.class, (Service)coordinator);
    }

    public void start() {
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

