/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance;

import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserPerfData;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.BrowserPerfDataDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.PerfDataParserListenerManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.PerfDataAnalysisListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfDataAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PerfDataAnalyzer.class);
    private final ModuleManager moduleManager;
    private final PerfDataParserListenerManager listenerManager;
    private final BrowserServiceModuleConfig config;
    private final List<PerfDataAnalysisListener> analysisListeners = new LinkedList<PerfDataAnalysisListener>();

    public void doAnalysis(BrowserPerfData browserPerfData) {
        this.createAnalysisListeners();
        BrowserPerfDataDecorator decorator = new BrowserPerfDataDecorator(browserPerfData);
        long nowMillis = System.currentTimeMillis();
        decorator.setTime(nowMillis);
        this.notifyListener(decorator);
        this.notifyListenerToBuild();
    }

    private void notifyListener(BrowserPerfDataDecorator decorator) {
        this.analysisListeners.forEach(listener -> listener.parse(decorator));
    }

    private void notifyListenerToBuild() {
        this.analysisListeners.forEach(PerfDataAnalysisListener::build);
    }

    private void createAnalysisListeners() {
        this.listenerManager.getPerfDataListenerFactories().forEach(factory -> this.analysisListeners.add(factory.create(this.moduleManager, this.config)));
    }

    @Generated
    public PerfDataAnalyzer(ModuleManager moduleManager, PerfDataParserListenerManager listenerManager, BrowserServiceModuleConfig config) {
        this.moduleManager = moduleManager;
        this.listenerManager = listenerManager;
        this.config = config;
    }
}

